<?php
/**
 * Reset Password Form Template
 *
 * Custom styled reset password form for AI Theme
 * This form is shown when user clicks the reset link in email
 *
 * @package AI_Theme
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_reset_password_form');
?>

<div class="ai-login-page py-8 md:py-12" data-theme="<?php echo esc_attr(get_option('ai_theme_style', 'modern')); ?>">
    <div class="ai-container-narrow">

        <!-- Reset Password Form -->
        <div class="max-w-md mx-auto">
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">

                <!-- Header -->
                <div class="px-6 py-4 bg-gray-50 border-b border-gray-100 text-center">
                    <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                        <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                    </div>
                    <h2 class="text-xl font-semibold text-gray-900">
                        <?php echo esc_html(ai_get_text('account.setNewPassword', ai_get_label('account.set_new_password', ''))); ?>
                    </h2>
                    <p class="text-sm text-gray-500 mt-1">
                        <?php echo esc_html(ai_get_text('account.setNewPasswordSubtitle', ai_get_label('account.set_new_password_subtitle', ''))); ?>
                    </p>
                </div>

                <div class="p-6">
                    <form method="post" class="woocommerce-ResetPassword lost_reset_password">

                        <!-- New Password field -->
                        <div class="mb-4">
                            <label for="password_1" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('account.newPassword', ai_get_label('account.new_password', ''))); ?> <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input type="password" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all pr-12" name="password_1" id="password_1" autocomplete="new-password" required />
                                <button type="button" onclick="togglePassword('password_1')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                    <svg class="w-5 h-5 show-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                    <svg class="w-5 h-5 hide-icon hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <!-- Confirm Password field -->
                        <div class="mb-6">
                            <label for="password_2" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('account.confirmPassword', ai_get_label('account.confirm_password', ''))); ?> <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input type="password" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all pr-12" name="password_2" id="password_2" autocomplete="new-password" required />
                                <button type="button" onclick="togglePassword('password_2')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                    <svg class="w-5 h-5 show-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                    <svg class="w-5 h-5 hide-icon hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <!-- Password strength hint -->
                        <div class="mb-6 p-4 bg-gray-50 rounded-lg">
                            <p class="text-xs text-gray-600 font-medium mb-2"><?php echo esc_html(ai_get_text('account.passwordRequirements', ai_get_label('account.password_requirements', ''))); ?></p>
                            <ul class="text-xs text-gray-500 space-y-1">
                                <li class="flex items-center gap-2">
                                    <svg class="w-3.5 h-3.5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                    <?php echo esc_html(ai_get_text('account.passwordMinLength', ai_get_label('account.password_min_length', ''))); ?>
                                </li>
                                <li class="flex items-center gap-2">
                                    <svg class="w-3.5 h-3.5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                    <?php echo esc_html(ai_get_text('account.passwordMix', ai_get_label('account.password_mix', ''))); ?>
                                </li>
                            </ul>
                        </div>

                        <?php do_action('woocommerce_resetpassword_form'); ?>

                        <input type="hidden" name="reset_key" value="<?php echo esc_attr($args['key']); ?>" />
                        <input type="hidden" name="reset_login" value="<?php echo esc_attr($args['login']); ?>" />
                        <input type="hidden" name="wc_reset_password" value="true" />
                        <?php wp_nonce_field('reset_password', 'woocommerce-reset-password-nonce'); ?>

                        <!-- Submit button -->
                        <button type="submit" class="w-full px-6 py-3 bg-primary text-white font-semibold rounded-lg hover:opacity-90 transition-opacity flex items-center justify-center gap-2" value="<?php esc_attr_e('Save', 'woocommerce'); ?>">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            <?php echo esc_html(ai_get_text('account.savePassword', ai_get_label('account.save_password', ''))); ?>
                        </button>

                    </form>
                </div>
            </div>
        </div>

    </div>
</div>

<script>
function togglePassword(inputId) {
    var input = document.getElementById(inputId);
    var parent = input.parentElement;
    var showIcon = parent.querySelector('.show-icon');
    var hideIcon = parent.querySelector('.hide-icon');

    if (input.type === 'password') {
        input.type = 'text';
        showIcon.classList.add('hidden');
        hideIcon.classList.remove('hidden');
    } else {
        input.type = 'password';
        showIcon.classList.remove('hidden');
        hideIcon.classList.add('hidden');
    }
}
</script>

<?php do_action('woocommerce_after_reset_password_form'); ?>
