<?php
/**
 * Login Form Template
 *
 * Custom styled login/register form for AI Theme
 *
 * @package AI_Theme
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_customer_login_form');
?>

<div class="ai-login-page py-8 md:py-12" data-theme="<?php echo esc_attr(get_option('ai_theme_style', 'modern')); ?>">
    <div class="ai-container-narrow">

        <?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) : ?>

        <!-- Two column layout: Login & Register -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">

            <!-- Login Form -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 bg-gray-50 border-b border-gray-100">
                    <h2 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                        </svg>
                        <?php echo esc_html(ai_get_text('account.login', ai_get_label('account.login', 'Login'))); ?>
                    </h2>
                </div>

                <div class="p-6">
                    <form class="woocommerce-form woocommerce-form-login login" method="post">
                        <?php do_action('woocommerce_login_form_start'); ?>

                        <div class="mb-4">
                            <label for="username" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('account.emailOrUsername', ai_get_label('account.email_or_username', 'Email or username'))); ?> <span class="text-red-500">*</span>
                            </label>
                            <input type="text" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all" name="username" id="username" autocomplete="username" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" required />
                        </div>

                        <div class="mb-4">
                            <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('account.password', ai_get_label('account.password', 'Password'))); ?> <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all pr-12" type="password" name="password" id="password" autocomplete="current-password" required />
                                <button type="button" onclick="togglePassword('password')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                    <svg class="w-5 h-5 show-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                    <svg class="w-5 h-5 hide-icon hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <?php do_action('woocommerce_login_form'); ?>

                        <div class="flex items-center justify-between mb-6">
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input class="w-4 h-4 text-primary border-gray-300 rounded focus:ring-primary" name="rememberme" type="checkbox" id="rememberme" value="forever" />
                                <span class="text-sm text-gray-600"><?php echo esc_html(ai_get_text('account.rememberMe', ai_get_label('account.remember_me', 'Remember me'))); ?></span>
                            </label>

                            <a href="<?php echo esc_url(wp_lostpassword_url()); ?>" class="text-sm text-primary hover:underline">
                                <?php echo esc_html(ai_get_text('account.forgotPassword', ai_get_label('account.forgot_password', 'Forgot password?'))); ?>
                            </a>
                        </div>

                        <?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>

                        <button type="submit" class="w-full px-6 py-3 bg-primary text-white font-semibold rounded-lg hover:opacity-90 transition-opacity flex items-center justify-center gap-2" name="login" value="<?php esc_attr_e('Log in', 'woocommerce'); ?>">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                            </svg>
                            <?php echo esc_html(ai_get_text('account.loginButton', ai_get_label('account.login_button', 'Log in'))); ?>
                        </button>

                        <?php do_action('woocommerce_login_form_end'); ?>
                    </form>
                </div>
            </div>

            <!-- Register Form -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 bg-gray-50 border-b border-gray-100">
                    <h2 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"></path>
                        </svg>
                        <?php echo esc_html(ai_get_text('account.register', ai_get_label('account.register', 'Register'))); ?>
                    </h2>
                </div>

                <div class="p-6">
                    <form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action('woocommerce_register_form_tag'); ?>>
                        <?php do_action('woocommerce_register_form_start'); ?>

                        <?php if ('no' === get_option('woocommerce_registration_generate_username')) : ?>
                        <div class="mb-4">
                            <label for="reg_username" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('account.username', ai_get_label('account.username', 'Username'))); ?> <span class="text-red-500">*</span>
                            </label>
                            <input type="text" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all" name="username" id="reg_username" autocomplete="username" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" required />
                        </div>
                        <?php endif; ?>

                        <div class="mb-4">
                            <label for="reg_email" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('common.form.email', ai_get_label('forms.email', 'Email'))); ?> <span class="text-red-500">*</span>
                            </label>
                            <input type="email" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all" name="email" id="reg_email" autocomplete="email" value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>" required />
                        </div>

                        <?php if ('no' === get_option('woocommerce_registration_generate_password')) : ?>
                        <div class="mb-4">
                            <label for="reg_password" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('account.password', ai_get_label('account.password', 'Password'))); ?> <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input type="password" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all pr-12" name="password" id="reg_password" autocomplete="new-password" required />
                                <button type="button" onclick="togglePassword('reg_password')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                    <svg class="w-5 h-5 show-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                    <svg class="w-5 h-5 hide-icon hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>
                        <?php else : ?>
                        <div class="mb-4 p-4 bg-blue-50 rounded-lg">
                            <p class="text-sm text-blue-700 flex items-center gap-2">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <?php echo esc_html(ai_get_text('account.passwordSentEmail', ai_get_label('account.password_sent_email', 'Password will be sent to your email.'))); ?>
                            </p>
                        </div>
                        <?php endif; ?>

                        <?php do_action('woocommerce_register_form'); ?>

                        <div class="mb-6">
                            <?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
                        </div>

                        <button type="submit" class="w-full px-6 py-3 bg-gray-900 text-white font-semibold rounded-lg hover:bg-gray-800 transition-colors flex items-center justify-center gap-2" name="register" value="<?php esc_attr_e('Register', 'woocommerce'); ?>">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"></path>
                            </svg>
                            <?php echo esc_html(ai_get_text('account.createAccount', ai_get_label('account.create_account', 'Create account'))); ?>
                        </button>

                        <?php do_action('woocommerce_register_form_end'); ?>
                    </form>
                </div>
            </div>
        </div>

        <?php else : ?>

        <!-- Single column: Login only -->
        <div class="max-w-md mx-auto">
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 bg-gray-50 border-b border-gray-100 text-center">
                    <h2 class="text-xl font-semibold text-gray-900"><?php echo esc_html(ai_get_text('account.loginToAccount', ai_get_label('account.login_to_account', 'Log in to your account'))); ?></h2>
                </div>

                <div class="p-6">
                    <form class="woocommerce-form woocommerce-form-login login" method="post">
                        <?php do_action('woocommerce_login_form_start'); ?>

                        <div class="mb-4">
                            <label for="username" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('account.emailOrUsername', ai_get_label('account.email_or_username', 'Email or username'))); ?> <span class="text-red-500">*</span>
                            </label>
                            <input type="text" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all" name="username" id="username" autocomplete="username" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" required />
                        </div>

                        <div class="mb-4">
                            <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('account.password', ai_get_label('account.password', 'Password'))); ?> <span class="text-red-500">*</span>
                            </label>
                            <input class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all" type="password" name="password" id="password" autocomplete="current-password" required />
                        </div>

                        <?php do_action('woocommerce_login_form'); ?>

                        <div class="flex items-center justify-between mb-6">
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input class="w-4 h-4 text-primary border-gray-300 rounded focus:ring-primary" name="rememberme" type="checkbox" id="rememberme" value="forever" />
                                <span class="text-sm text-gray-600"><?php echo esc_html(ai_get_text('account.rememberMe', ai_get_label('account.remember_me', 'Remember me'))); ?></span>
                            </label>

                            <a href="<?php echo esc_url(wp_lostpassword_url()); ?>" class="text-sm text-primary hover:underline">
                                <?php echo esc_html(ai_get_text('account.forgotPassword', ai_get_label('account.forgot_password', 'Forgot password?'))); ?>
                            </a>
                        </div>

                        <?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>

                        <button type="submit" class="w-full px-6 py-3 bg-primary text-white font-semibold rounded-lg hover:opacity-90 transition-opacity" name="login" value="<?php esc_attr_e('Log in', 'woocommerce'); ?>">
                            <?php echo esc_html(ai_get_text('account.loginButton', ai_get_label('account.login_button', 'Log in'))); ?>
                        </button>

                        <?php do_action('woocommerce_login_form_end'); ?>
                    </form>
                </div>
            </div>
        </div>

        <?php endif; ?>

    </div>
</div>

<script>
function togglePassword(inputId) {
    var input = document.getElementById(inputId);
    var parent = input.parentElement;
    var showIcon = parent.querySelector('.show-icon');
    var hideIcon = parent.querySelector('.hide-icon');

    if (input.type === 'password') {
        input.type = 'text';
        showIcon.classList.add('hidden');
        hideIcon.classList.remove('hidden');
    } else {
        input.type = 'password';
        showIcon.classList.remove('hidden');
        hideIcon.classList.add('hidden');
    }
}
</script>

<?php do_action('woocommerce_after_customer_login_form'); ?>
