<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Testimonials_Featured extends AI_Widget_Base {
    public function get_name() { return 'ai_testimonials_featured'; }
    public function get_title() { return __('Testimonials Masonry', 'ai-theme'); }
    public function get_icon() { return 'eicon-gallery-masonry'; }
    public function get_categories() { return array('ai-theme-testimonials'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subtitle', ['label' => __('Subtitle', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('name', ['label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('position', ['label' => __('Position', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('content', ['label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('avatar', ['label' => __('Avatar', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('rating', ['label' => __('Rating', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 5, 'min' => 1, 'max' => 5]);
        $this->add_control('testimonials', ['label' => __('Testimonials', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $title = !empty($s['title']) ? $s['title'] : ai_get_text('blocks.testimonials.heading', '');
        $subtitle = !empty($s['subtitle']) ? $s['subtitle'] : ai_get_text('blocks.testimonials.subheading', '');
        $testimonials = !empty($s['testimonials']) ? $s['testimonials'] : [];
        
        if (empty($testimonials)) return;
        
        $cardStyles = [
            'bg-[var(--primary)] text-[var(--text-on-primary)]',
            'bg-[var(--bg-primary)] text-[var(--text-primary)] border border-[var(--border-color,#e5e7eb)]',
            'bg-[var(--bg-dark,#111827)] text-[var(--text-on-dark)]',
            'bg-[var(--secondary)] text-[var(--text-on-primary)]',
            'bg-[var(--primary)] text-[var(--text-on-primary)] opacity-90',
            'bg-[var(--secondary)] text-[var(--text-on-primary)] opacity-90',
        ];
        ?>
        <section class="py-16 section-secondary" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="testimonials" data-block-variant="testimonials-featured">
            <div class="max-w-6xl mx-auto px-6">
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($title); ?></h2>
                    <p class="text-lg text-[var(--text-secondary)]"><?php echo esc_html($subtitle); ?></p>
                </div>

                <div class="columns-1 sm:columns-2 lg:columns-3 gap-4 space-y-4">
                    <?php foreach ($testimonials as $idx => $t) : 
                        $style = $cardStyles[$idx % count($cardStyles)];
                        $isLight = strpos($style, 'bg-white') !== false || strpos($style, 'bg-amber') !== false;
                        $rating = isset($t['rating']) ? (int)$t['rating'] : 5;
                    ?>
                    <div class="break-inside-avoid rounded-2xl p-6 <?php echo esc_attr($style); ?>">
                        <svg class="w-8 h-8 mb-4 <?php echo $isLight ? 'text-[var(--text-muted)]' : 'opacity-30'; ?>" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z"/>
                        </svg>
                        <p class="text-base leading-relaxed mb-5">"<?php echo esc_html($t['content'] ?? ''); ?>"</p>
                        <div class="flex gap-0.5 mb-4">
                            <?php for ($i = 0; $i < 5; $i++) : ?>
                            <span class="text-sm <?php echo $i < $rating ? 'opacity-100' : 'opacity-30'; ?>">⭐</span>
                            <?php endfor; ?>
                        </div>
                        <div class="flex items-center gap-3">
                            <?php if (!empty($t['avatar']['url'])) : ?>
                            <img src="<?php echo esc_url($t['avatar']['url']); ?>" alt="<?php echo esc_attr($t['name'] ?? ''); ?>" class="w-10 h-10 rounded-full object-cover">
                            <?php else : ?>
                            <div class="w-10 h-10 rounded-full flex items-center justify-center <?php echo $isLight ? 'bg-[var(--bg-secondary)] text-[var(--text-secondary)]' : 'bg-[var(--bg-primary)]/20 text-[var(--text-on-primary)]'; ?> font-bold">
                                <?php echo esc_html(mb_substr($t['name'] ?? 'U', 0, 1)); ?>
                            </div>
                            <?php endif; ?>
                            <div>
                                <div class="font-semibold text-sm"><?php echo esc_html($t['name'] ?? ''); ?></div>
                                <?php if (!empty($t['position'])) : ?>
                                <div class="text-xs <?php echo $isLight ? 'text-[var(--text-muted)]' : 'opacity-70'; ?>"><?php echo esc_html($t['position']); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
