<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Shipping_Timeline extends AI_Widget_Base {
    public function get_name() { return 'ai_shipping_timeline'; }
    public function get_title() { return __('Shipping Timeline', 'ai-theme'); }
    public function get_icon() { return 'eicon-delivery'; }
    public function get_categories() { return array('ai-theme-shipping'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('free_shipping_from', array('label' => __('Free Shipping From', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 5000));

        $repeater = new Repeater();
        $repeater->add_control('step', array('label' => __('Step', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));

        $this->add_control('steps', array('label' => __('Steps', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $free_from = intval($settings['free_shipping_from']);
        $colors = ['from-blue-500 to-blue-600', 'from-indigo-500 to-indigo-600', 'from-purple-500 to-purple-600', 'from-pink-500 to-pink-600'];
        ?>
        <section class="py-16 bg-gradient-to-b from-[var(--bg-primary)] to-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="shipping" data-block-variant="shipping-timeline">
            <div class="max-w-5xl mx-auto px-4">
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-3xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['subheading'])) : ?>
                    <p class="text-[var(--text-secondary)]"><?php echo esc_html($settings['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Timeline -->
                <div class="relative mb-16">
                    <!-- Line -->
                    <div class="absolute top-8 left-0 right-0 h-1 bg-[var(--border-color)] hidden md:block"></div>
                    <div class="absolute top-8 left-0 right-0 h-1 bg-gradient-to-r from-blue-500 via-indigo-500 to-purple-500 hidden md:block"></div>

                    <div class="flex flex-col md:flex-row justify-between gap-8 md:gap-4">
                        <?php foreach ($settings['steps'] as $idx => $step) : 
                            $color = $colors[$idx % count($colors)];
                        ?>
                        <div class="flex-1 text-center relative">
                            <div class="w-16 h-16 bg-gradient-to-br <?php echo $color; ?> rounded-full flex items-center justify-center mx-auto mb-4 relative z-10 shadow-lg">
                                <?php if ($idx === 0) : ?>
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                </svg>
                                <?php elseif ($idx === 1) : ?>
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path>
                                </svg>
                                <?php else : ?>
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                                </svg>
                                <?php endif; ?>
                            </div>
                            <h3 class="font-bold text-[var(--text-primary)] mb-1"><?php echo esc_html($step['step']); ?></h3>
                            <?php if (!empty($step['description'])) : ?>
                            <p class="text-sm text-[var(--text-muted)]"><?php echo esc_html($step['description']); ?></p>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Free Shipping Notice -->
                <?php if ($free_from > 0) : ?>
                <div class="bg-gradient-to-r from-emerald-50 to-teal-50 border border-emerald-200 rounded-xl p-6 text-center">
                    <svg class="w-12 h-12 text-emerald-500 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h3 class="text-xl font-bold text-[var(--text-primary)] mb-2"><?php echo ai_get_text('shipping.freeShipping', __('Free shipping', 'ai-theme')); ?></h3>
                    <p class="text-[var(--text-secondary)]"><?php printf(ai_get_text('shipping.onOrdersFrom', __('On orders from %s', 'ai-theme')), number_format($free_from, 0, ',', ' ')); ?></p>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
