<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Shipping_Table extends AI_Widget_Base {
    public function get_name() { return 'ai_shipping_table'; }
    public function get_title() { return __('Shipping Table', 'ai-theme'); }
    public function get_icon() { return 'eicon-delivery'; }
    public function get_categories() { return array('ai-theme-shipping'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('free_shipping_from', array('label' => __('Free Shipping From', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 0));

        $repeater = new Repeater();
        $repeater->add_control('region', array('label' => __('Region', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('price', array('label' => __('Price', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('time', array('label' => __('Delivery Time', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $this->add_control('rates', array('label' => __('Rates', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $free_from = intval($settings['free_shipping_from']);
        ?>
        <section class="py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="shipping" data-block-variant="shipping-table">
            <div class="max-w-4xl mx-auto px-4">
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-3xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['subheading'])) : ?>
                    <p class="text-[var(--text-secondary)]"><?php echo esc_html($settings['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Free Shipping Banner -->
                <?php if ($free_from > 0) : ?>
                <div class="bg-gradient-to-r from-emerald-500 to-teal-600 text-white rounded-xl p-4 mb-8 flex items-center justify-center gap-3">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path>
                    </svg>
                    <span class="font-semibold"><?php printf(__('Free shipping from %s', 'ai-theme'), number_format($free_from, 0, ',', ' ')); ?></span>
                </div>
                <?php endif; ?>

                <!-- Table -->
                <div class="bg-[var(--bg-secondary)] rounded-xl overflow-hidden shadow-sm">
                    <table class="w-full">
                        <thead class="bg-[var(--bg-dark)] text-[var(--text-on-dark)]">
                            <tr>
                                <th class="px-6 py-4 text-left font-semibold"><?php _e('Region', 'ai-theme'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold"><?php _e('Price', 'ai-theme'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold"><?php _e('Time', 'ai-theme'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-[var(--border-color)]">
                            <?php foreach ($settings['rates'] as $idx => $rate) : ?>
                            <tr class="<?php echo $idx % 2 === 0 ? 'bg-[var(--bg-primary)]' : 'bg-[var(--bg-secondary)]'; ?> hover:bg-[var(--primary-light,#dbeafe)] transition-colors">
                                <td class="px-6 py-4">
                                    <span class="font-medium text-[var(--text-primary)]"><?php echo esc_html($rate['region']); ?></span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="font-bold text-[var(--primary)]"><?php echo esc_html($rate['price']); ?></span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="text-[var(--text-secondary)]"><?php echo esc_html($rate['time']); ?></span>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <?php
    }
}
