<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Services_Grid extends AI_Widget_Base {
    public function get_name() { return 'ai_services_grid'; }
    public function get_title() { return __('Services Grid', 'ai-theme'); }
    public function get_icon() { return 'eicon-gallery-grid'; }
    public function get_categories() { return array('ai-theme-services'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subtitle', ['label' => __('Subtitle', 'ai-theme'), 'type' => Controls_Manager::TEXT]);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('icon', ['label' => __('Icon', 'ai-theme'), 'type' => Controls_Manager::ICONS]);
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $this->add_control('services', ['label' => __('Services', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-services ai-services-grid section-light py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="services" data-block-variant="services-grid">
            <div class="ai-container">
                <div class="ai-services-header text-center mb-12">
                    <h2 class="ai-services-title text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['title']); ?></h2>
                    <?php if (!empty($s['subtitle'])) : ?><p class="ai-services-subtitle text-lg text-[var(--text-secondary)]"><?php echo esc_html($s['subtitle']); ?></p><?php endif; ?>
                </div>
                <div class="ai-services-items grid md:grid-cols-2 gap-8">
                    <?php foreach ($s['services'] as $svc) : ?>
                    <div class="ai-service-item bg-[var(--primary-light)] p-8 rounded-2xl border border-[var(--border-color,#e5e7eb)] hover:shadow-xl transition-all">
                        <div class="mb-4">
                            <?php if (!empty($svc['image']['url'])) : ?>
                                <img src="<?php echo esc_url($svc['image']['url']); ?>" alt="<?php echo esc_attr($svc['title']); ?>" class="w-24 h-24 object-cover rounded-lg">
                            <?php elseif (!empty($svc['icon']['value'])) : ?>
                                <i class="<?php echo esc_attr($svc['icon']['value']); ?> text-5xl text-[var(--primary)]"></i>
                            <?php endif; ?>
                        </div>
                        <h3 class="text-2xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($svc['title']); ?></h3>
                        <div class="text-[var(--text-secondary)] prose prose-sm max-w-none"><?php echo wp_kses_post($svc['description']); ?></div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
