<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

/**
 * ProcessMinimal - Minimal clean design
 * Gray background, white cards in 4-col grid, large faded numbers (01, 02...)
 */
class Process_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_process_minimal'; }
    public function get_title() { return __('Process Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-posts-grid'; }
    public function get_categories() { return array('ai-theme-process'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $this->add_control('steps', [
            'label' => __('Steps', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => []
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $steps = !empty($s['steps']) ? $s['steps'] : [];
        ?>
        <section class="w-full section-secondary py-16 md:py-20" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="process" data-block-variant="process-minimal">
            <div class="max-w-6xl mx-auto px-6">
                <!-- Header -->
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-sm text-[var(--text-muted)] mb-2"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)]"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Desktop Grid -->
                <div class="hidden md:grid md:grid-cols-4 gap-6">
                    <?php foreach ($steps as $i => $step) : ?>
                    <div class="relative bg-[var(--bg-primary)] rounded-xl p-6 border border-[var(--border-color,#e5e7eb)] hover:border-[var(--primary-light)] hover:shadow-md transition-all cursor-pointer group">
                        <!-- Large faded number -->
                        <div class="mb-4">
                            <span class="text-4xl font-bold text-[var(--border-color,#e5e7eb)] group-hover:text-[var(--primary)] transition-colors duration-300">
                                <?php echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?>
                            </span>
                        </div>

                        <!-- Content -->
                        <h3 class="text-lg font-semibold text-[var(--text-primary)] mb-2"><?php echo esc_html($step['title']); ?></h3>
                        <?php if (!empty($step['description'])) : ?>
                        <p class="text-sm text-[var(--text-muted)] line-clamp-2"><?php echo esc_html($step['description']); ?></p>
                        <?php endif; ?>

                        <!-- Connector arrow -->
                        <?php if ($i < count($steps) - 1) : ?>
                        <div class="absolute -right-3 top-1/2 -translate-y-1/2 z-10 w-6 h-6 bg-[var(--bg-primary)] border border-[var(--border-color,#e5e7eb)] rounded-full flex items-center justify-center">
                            <svg class="w-3 h-3 text-[var(--text-muted)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Mobile List -->
                <div class="md:hidden space-y-4">
                    <?php foreach ($steps as $i => $step) : ?>
                    <div class="bg-[var(--bg-primary)] rounded-xl p-5 border border-[var(--border-color,#e5e7eb)]">
                        <div class="flex items-start gap-4">
                            <!-- Number -->
                            <span class="text-2xl font-bold text-[var(--border-color,#e5e7eb)]">
                                <?php echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?>
                            </span>

                            <!-- Content -->
                            <div class="flex-1">
                                <h3 class="text-lg font-semibold text-[var(--text-primary)] mb-1"><?php echo esc_html($step['title']); ?></h3>
                                <?php if (!empty($step['description'])) : ?>
                                <p class="text-sm text-[var(--text-muted)]"><?php echo esc_html($step['description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
