<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

/**
 * ProcessAlternating - Alternating layout
 * White background, alternating left-right positioning, colored circle numbers
 */
class Process_Alternating extends AI_Widget_Base {
    public function get_name() { return 'ai_process_alternating'; }
    public function get_title() { return __('Process Alternating', 'ai-theme'); }
    public function get_icon() { return 'eicon-exchange'; }
    public function get_categories() { return array('ai-theme-process'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $this->add_control('steps', [
            'label' => __('Steps', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => []
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $steps = !empty($s['steps']) ? $s['steps'] : [];

        // Color schemes for cards
        $colors = [
            ['bg' => '#eff6ff', 'primary' => '#3b82f6'], // blue
            ['bg' => '#f0fdf4', 'primary' => '#22c55e'], // green
            ['bg' => '#faf5ff', 'primary' => '#a855f7'], // purple
            ['bg' => '#fff7ed', 'primary' => '#f97316'], // orange
        ];
        ?>
        <section class="w-full bg-[var(--bg-primary)] py-16 md:py-20" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="process" data-block-variant="process-alternating">
            <div class="max-w-5xl mx-auto px-6">
                <!-- Header -->
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-sm text-[var(--text-muted)] mb-2"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)]"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Steps -->
                <div class="space-y-8">
                    <?php foreach ($steps as $i => $step) :
                        $isEven = $i % 2 === 0;
                        $color = $colors[$i % count($colors)];
                    ?>
                    <div class="relative">
                        <div class="flex flex-col md:flex-row items-center gap-6 <?php echo !$isEven ? 'md:flex-row-reverse' : ''; ?>">
                            <!-- Number circle -->
                            <div class="flex-shrink-0 w-16 h-16 rounded-full flex items-center justify-center text-2xl font-bold text-white" style="background-color: <?php echo esc_attr($color['primary']); ?>">
                                <?php echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); ?>
                            </div>

                            <!-- Content card -->
                            <div class="flex-1 p-6 rounded-xl <?php echo $isEven ? 'md:text-left' : 'md:text-right'; ?>" style="background-color: <?php echo esc_attr($color['bg']); ?>">
                                <h3 class="text-xl font-semibold text-[var(--text-primary)] mb-2"><?php echo esc_html($step['title']); ?></h3>
                                <?php if (!empty($step['description'])) : ?>
                                <p class="text-[var(--text-secondary)]"><?php echo esc_html($step['description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Connector line -->
                        <?php if ($i < count($steps) - 1) : ?>
                        <div class="hidden md:flex justify-center py-2">
                            <div class="w-px h-8 bg-[var(--border-color)]"></div>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
