<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Newsletter_Inline extends AI_Widget_Base {
    public function get_name() { return 'ai_newsletter_inline'; }
    public function get_title() { return __('Newsletter Inline', 'ai-theme'); }
    public function get_icon() { return 'eicon-email-field'; }
    public function get_categories() { return array('ai-theme-forms'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('placeholder', ['label' => __('Email Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('button_text', ['label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="section-secondary py-12" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="newsletter" data-block-variant="newsletter-inline">
            <div class="max-w-3xl mx-auto px-6">
                <div class="text-center mb-8">
                    <?php if (!empty($s['heading'])) : ?>
                    <h3 class="text-2xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($s['heading']); ?></h3>
                    <?php endif; ?>
                    <?php if (!empty($s['description'])) : ?>
                    <p class="text-[var(--text-secondary)]"><?php echo esc_html($s['description']); ?></p>
                    <?php endif; ?>
                </div>

                <form class="max-w-xl mx-auto">
                    <div class="flex justify-center gap-3">
                        <input type="email" placeholder="<?php echo esc_attr($s['placeholder']); ?>" class="w-72 px-5 py-4 bg-[var(--bg-primary)] border border-[var(--border-color)] rounded-xl text-[var(--text-primary)] placeholder-[var(--text-muted)] focus:outline-none focus:border-[var(--primary)] transition-colors">
                        <button type="submit" class="px-8 py-4 bg-[var(--primary)] hover:opacity-90 text-[var(--text-on-primary)] font-semibold rounded-xl transition-colors flex items-center gap-2">
                            <?php echo esc_html($s['button_text']); ?>
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/></svg>
                        </button>
                    </div>
                </form>
            </div>
        </section>
        <?php
    }
}
