<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Newsletter_Centered extends AI_Widget_Base {
    public function get_name() { return 'ai_newsletter_centered'; }
    public function get_title() { return __('Newsletter Centered', 'ai-theme'); }
    public function get_icon() { return 'eicon-email-field'; }
    public function get_categories() { return array('ai-theme-forms'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('placeholder', ['label' => __('Email Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('button_text', ['label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('privacy_note', ['label' => __('Privacy Note', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="w-full py-16 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="newsletter" data-block-variant="newsletter-centered">
            <div class="max-w-3xl mx-auto px-6 text-center">
                <?php if (!empty($s['heading'])) : ?>
                <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h2>
                <?php endif; ?>

                <?php if (!empty($s['description'])) : ?>
                <p class="text-lg text-[var(--text-secondary)] mb-8 max-w-2xl mx-auto"><?php echo esc_html($s['description']); ?></p>
                <?php endif; ?>

                <form class="max-w-md mx-auto">
                    <div class="flex flex-col sm:flex-row gap-3">
                        <div class="flex-1 relative">
                            <svg class="absolute left-4 top-1/2 -translate-y-1/2 w-5 h-5 text-[var(--text-muted)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                            <input type="email" placeholder="<?php echo esc_attr($s['placeholder']); ?>" class="w-full pl-12 pr-4 py-4 rounded-lg border border-[var(--border-color)] focus:border-[var(--primary)] focus:outline-none bg-[var(--bg-primary)]">
                        </div>
                        <button type="submit" class="px-8 py-4 bg-[var(--primary)] text-[var(--text-on-primary)] rounded-lg font-semibold hover:opacity-90 transition-colors flex items-center justify-center gap-2">
                            <?php echo esc_html($s['button_text']); ?>
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                        </button>
                    </div>
                </form>

                <?php if (!empty($s['privacy_note'])) : ?>
                <p class="mt-4 text-sm text-[var(--text-muted)]"><?php echo esc_html($s['privacy_note']); ?></p>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
