<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Modal_Order extends AI_Widget_Base {
    public function get_name() { return 'ai_modal_order'; }
    public function get_title() { return __('Modal Order', 'ai-theme'); }
    public function get_icon() { return 'eicon-cart'; }
    public function get_categories() { return array('ai-theme-modal'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('button_text', ['label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('modal_title', ['label' => __('Modal Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('name_placeholder', ['label' => __('Name Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('phone_placeholder', ['label' => __('Phone Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('address_placeholder', ['label' => __('Address Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('notes_placeholder', ['label' => __('Notes Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('submit_text', ['label' => __('Submit Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $id = 'ai-modal-' . $this->get_id();
        ?>
        <div class="ai-modal-trigger" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="modal" data-block-variant="modal-order">
            <button class="ai-modal-open bg-orange-600 text-white px-6 py-3 rounded-lg hover:bg-orange-700 transition-colors font-medium" data-modal="<?php echo esc_attr($id); ?>"><?php echo esc_html($s['button_text']); ?></button>
        </div>
        <div class="ai-modal fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm" id="<?php echo esc_attr($id); ?>">
            <div class="ai-modal-content ai-modal-order max-w-2xl w-full bg-white rounded-2xl shadow-2xl p-8 relative max-h-[90vh] overflow-y-auto">
                <button class="ai-modal-close absolute top-4 right-4 text-[var(--text-muted)] hover:text-[var(--text-secondary)] transition-colors text-2xl">&times;</button>
                <div class="mb-6">
                    <h3 class="text-3xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($s['modal_title']); ?></h3>
                </div>
                <form class="ai-modal-form space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <input type="text" placeholder="<?php echo esc_attr($s['name_placeholder']); ?>" required class="w-full px-4 py-2 rounded-lg border border-[var(--border-color)] bg-[var(--bg-primary)] text-[var(--text-primary)] focus:ring-2 focus:ring-orange-200 focus:border-orange-500">
                        </div>
                        <div>
                            <input type="tel" placeholder="<?php echo esc_attr($s['phone_placeholder']); ?>" required class="w-full px-4 py-2 rounded-lg border border-[var(--border-color)] bg-[var(--bg-primary)] text-[var(--text-primary)] focus:ring-2 focus:ring-orange-200 focus:border-orange-500">
                        </div>
                        <div class="md:col-span-2">
                            <input type="text" placeholder="<?php echo esc_attr($s['address_placeholder']); ?>" required class="w-full px-4 py-2 rounded-lg border border-[var(--border-color)] bg-[var(--bg-primary)] text-[var(--text-primary)] focus:ring-2 focus:ring-orange-200 focus:border-orange-500">
                        </div>
                        <div class="md:col-span-2">
                            <textarea placeholder="<?php echo esc_attr($s['notes_placeholder']); ?>" rows="3" class="w-full px-4 py-2 rounded-lg border border-[var(--border-color)] bg-[var(--bg-primary)] text-[var(--text-primary)] focus:ring-2 focus:ring-orange-200 focus:border-orange-500"></textarea>
                        </div>
                    </div>
                    <button type="submit" class="w-full bg-orange-600 text-white py-3 rounded-lg hover:bg-orange-700 transition-colors font-medium"><?php echo esc_html($s['submit_text']); ?></button>
                </form>
            </div>
        </div>
        <?php
    }
}
