<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Modal_Info extends AI_Widget_Base {
    public function get_name() { return 'ai_modal_info'; }
    public function get_title() { return __('Modal Info', 'ai-theme'); }
    public function get_icon() { return 'eicon-info-circle'; }
    public function get_categories() { return array('ai-theme-modal'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('button_text', ['label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('modal_title', ['label' => __('Modal Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('modal_content', ['label' => __('Modal Content', 'ai-theme'), 'type' => Controls_Manager::WYSIWYG]);
        $this->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $this->add_control('close_text', ['label' => __('Close Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $id = 'ai-modal-' . $this->get_id();
        ?>
        <div class="ai-modal-trigger" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="modal" data-block-variant="modal-info">
            <button class="ai-modal-open bg-[var(--text-secondary)] text-white px-6 py-3 rounded-lg hover:opacity-90 transition-colors font-medium" data-modal="<?php echo esc_attr($id); ?>"><?php echo esc_html($s['button_text']); ?></button>
        </div>
        <div class="ai-modal fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm" id="<?php echo esc_attr($id); ?>">
            <div class="ai-modal-content ai-modal-info max-w-lg w-full bg-white rounded-2xl shadow-2xl p-8 relative max-h-[80vh] overflow-y-auto">
                <button class="ai-modal-close absolute top-4 right-4 text-[var(--text-muted)] hover:text-[var(--text-secondary)] transition-colors text-2xl">&times;</button>
                <?php if (!empty($s['image']['url'])) : ?>
                <img src="<?php echo esc_url($s['image']['url']); ?>" alt="" class="ai-modal-image w-full rounded-lg mb-6">
                <?php endif; ?>
                <div class="mb-6">
                    <?php if (!empty($s['modal_title'])) : ?>
                    <h3 class="text-3xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['modal_title']); ?></h3>
                    <?php endif; ?>
                    <?php if (!empty($s['modal_content'])) : ?>
                    <div class="ai-modal-body prose max-w-none text-[var(--text-secondary)]"><?php echo wp_kses_post($s['modal_content']); ?></div>
                    <?php endif; ?>
                </div>
                <div class="flex justify-end">
                    <button class="ai-modal-close-btn bg-[var(--primary)] text-white px-6 py-3 rounded-lg hover:opacity-90 transition-colors font-medium"><?php echo esc_html($s['close_text']); ?></button>
                </div>
            </div>
        </div>
        <?php
    }
}
