<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Map_Full extends AI_Widget_Base {
    public function get_name() { return 'ai_map_full'; }
    public function get_title() { return __('Map Full', 'ai-theme'); }
    public function get_icon() { return 'eicon-google-maps'; }
    public function get_categories() { return array('ai-theme-map'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('embed_url', ['label' => __('Google Maps Embed URL', 'ai-theme'), 'type' => Controls_Manager::URL]);
        $this->add_control('height', ['label' => __('Height', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '600px']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $this->add_control('markers', [
            'label' => __('Location Markers', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $markers = $s['markers'] ?? [];
        ?>
        <section class="ai-map ai-map-full w-full section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="map" data-block-variant="map-full">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-lg text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <?php if (!empty($s['embed_url']['url'])) : ?>
                <div class="bg-[var(--bg-primary)] rounded-2xl overflow-hidden shadow-xl">
                    <iframe src="<?php echo esc_url($s['embed_url']['url']); ?>" width="100%" height="<?php echo esc_attr($s['height']); ?>" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade" class="w-full"></iframe>
                </div>
                <?php endif; ?>

                <?php if (!empty($markers)) : ?>
                <div class="mt-8 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php foreach ($markers as $marker) : ?>
                    <div class="bg-[var(--bg-primary)] rounded-xl p-6 shadow-sm hover:shadow-lg transition-shadow">
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-10 h-10 bg-[var(--primary-light)] rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                            </div>
                            <div>
                                <?php if (!empty($marker['title'])) : ?>
                                <h3 class="text-lg font-bold text-[var(--text-primary)] mb-1"><?php echo esc_html($marker['title']); ?></h3>
                                <?php endif; ?>
                                <?php if (!empty($marker['description'])) : ?>
                                <p class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($marker['description']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
