<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Features_List extends AI_Widget_Base {
    public function get_name() { return 'ai_features_list'; }
    public function get_title() { return __('Features List', 'ai-theme'); }
    public function get_icon() { return 'eicon-bullet-list'; }
    public function get_categories() { return array('ai-theme-features'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subtitle', ['label' => __('Subtitle', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('features', ['label' => __('Features', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-features ai-features-list py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="features" data-block-variant="features-list">
            <div class="ai-container-narrow">
                <div class="text-center mb-12">
                    <h2 class="text-4xl font-bold mb-4"><?php echo esc_html($s['title']); ?></h2>
                    <?php if (!empty($s['subtitle'])) : ?>
                    <p class="text-xl text-[var(--text-secondary)]"><?php echo esc_html($s['subtitle']); ?></p>
                    <?php endif; ?>
                </div>
                <div class="space-y-6">
                    <?php $idx = 0; foreach ($s['features'] as $f) : ?>
                    <div class="ai-feature-item flex gap-4 items-start p-6 rounded-lg shadow-sm border border-[var(--border-color,#e5e7eb)] hover:shadow-md transition-shadow">
                        <div class="flex-shrink-0">
                            <div class="w-10 h-10 rounded-lg flex items-center justify-center font-bold text-lg relative">
                                <div class="absolute inset-0 rounded-lg bg-[var(--primary)] opacity-10"></div>
                                <span class="relative z-10 text-[var(--primary)]"><?php echo $idx + 1; ?></span>
                            </div>
                        </div>
                        <div class="flex-1 mt-1">
                            <h3 class="text-xl font-semibold text-[var(--text-primary)] mb-2"><?php echo esc_html($f['title']); ?></h3>
                            <div class="text-[var(--text-secondary)] prose prose-sm max-w-none"><?php echo wp_kses_post($f['description']); ?></div>
                        </div>
                    </div>
                    <?php $idx++; endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
