<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class FAQ_Two_Column extends AI_Widget_Base {
    public function get_name() { return 'ai_faq_two_column'; }
    public function get_title() { return __('FAQ Two Column', 'ai-theme'); }
    public function get_icon() { return 'eicon-posts-grid'; }
    public function get_categories() { return array('ai-theme-faq'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('question', ['label' => __('Question', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('answer', ['label' => __('Answer', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('faqs', ['label' => __('FAQ Items', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-faq ai-faq-two-column section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="faq" data-block-variant="faq-two-column">
            <div class="ai-container">
                <div class="text-center mb-12">
                    <h2 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['title']); ?></h2>
                </div>
                <div class="grid md:grid-cols-2 gap-8">
                    <?php foreach ($s['faqs'] as $f) : ?>
                    <div class="ai-faq-item bg-[var(--bg-primary)] p-6 rounded-xl border border-[var(--border-color,#e5e7eb)]">
                        <div class="flex items-start gap-3 mb-3">
                            <div class="w-8 h-8 bg-[var(--primary-light)] rounded-lg flex items-center justify-center flex-shrink-0">
                                <span class="text-[var(--primary)] text-xl">❓</span>
                            </div>
                            <h3 class="font-bold text-[var(--text-primary)] text-lg"><?php echo esc_html($f['question']); ?></h3>
                        </div>
                        <div class="text-[var(--text-secondary)] leading-relaxed pl-11 prose prose-sm max-w-none"><?php echo wp_kses_post($f['answer']); ?></div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
