<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class FAQ_Search extends AI_Widget_Base {
    public function get_name() { return 'ai_faq_search'; }
    public function get_title() { return __('FAQ Search', 'ai-theme'); }
    public function get_icon() { return 'eicon-help-o'; }
    public function get_categories() { return array('ai-theme-general'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('search_placeholder', array('label' => __('Search Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('question', array('label' => __('Question', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('answer', array('label' => __('Answer', 'ai-theme'), 'type' => Controls_Manager::WYSIWYG));

        $this->add_control('faqs', array('label' => __('FAQs', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $widget_id = $this->get_id();
        ?>
        <section class="py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="faq" data-block-variant="faq-search">
            <div class="max-w-3xl mx-auto px-6">
                <h2 class="text-3xl font-bold text-[var(--text-primary)] text-center mb-8"><?php echo esc_html($settings['heading']); ?></h2>
                <div class="mb-8">
                    <input type="text" id="faq-search-<?php echo esc_attr($widget_id); ?>" placeholder="<?php echo esc_attr($settings['search_placeholder']); ?>" class="w-full px-4 py-3 border border-[var(--border-color)] rounded-[var(--button-radius)] bg-[var(--bg-primary)] text-[var(--text-primary)] focus:outline-none focus:border-[var(--primary)]" />
                </div>
                <div class="space-y-4" id="faq-list-<?php echo esc_attr($widget_id); ?>">
                    <?php foreach ($settings['faqs'] as $idx => $faq) : ?>
                        <div class="faq-item border border-[var(--border-color)] rounded-[var(--card-radius)] overflow-hidden" data-question="<?php echo esc_attr(strtolower($faq['question'])); ?>">
                            <button class="faq-btn w-full px-6 py-4 flex justify-between items-center text-left hover:bg-[var(--bg-secondary)] transition-colors" data-target="faq-<?php echo esc_attr($widget_id . '-' . $idx); ?>">
                                <span class="font-medium text-[var(--text-primary)]"><?php echo esc_html($faq['question']); ?></span>
                                <svg class="w-5 h-5 text-[var(--text-secondary)] faq-icon transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                            </button>
                            <div id="faq-<?php echo esc_attr($widget_id . '-' . $idx); ?>" class="hidden px-6 pb-4">
                                <div class="prose prose-sm max-w-none text-[var(--text-secondary)]"><?php echo wp_kses_post($faq['answer']); ?></div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <script>
        (function() {
            const search = document.getElementById('faq-search-<?php echo esc_attr($widget_id); ?>');
            const items = document.querySelectorAll('#faq-list-<?php echo esc_attr($widget_id); ?> .faq-item');
            search?.addEventListener('input', function() {
                const q = this.value.toLowerCase();
                items.forEach(item => {
                    item.style.display = item.dataset.question.includes(q) ? '' : 'none';
                });
            });
            document.querySelectorAll('.faq-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    const content = document.getElementById(this.dataset.target);
                    const icon = this.querySelector('.faq-icon');
                    content.classList.toggle('hidden');
                    icon.style.transform = content.classList.contains('hidden') ? '' : 'rotate(180deg)';
                });
            });
        })();
        </script>
        <?php
    }
}
