<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class CTA_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_cta_minimal'; }
    public function get_title() { return __('CTA Card', 'ai-theme'); }
    public function get_icon() { return 'eicon-call-to-action'; }
    public function get_categories() { return array('ai-theme-cta'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $this->add_control('button_text', array('label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('button_link', array('label' => __('Button Link', 'ai-theme'), 'type' => Controls_Manager::URL));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $buttonText = !empty($settings['button_text']) ? $settings['button_text'] : ai_get_text('cta.buttonText', '');
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <div data-theme="<?php echo esc_attr($theme); ?>" class="ai-theme-block">
            <section class="py-16 section-secondary" data-block-type="cta" data-block-variant="cta-minimal">
                <div class="max-w-3xl mx-auto px-6">
                    <div class="bg-[var(--bg-primary)] rounded-2xl shadow-xl p-8 md:p-12 text-center">
                        <div class="w-16 h-16 bg-[var(--primary-light)] rounded-2xl flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>

                        <h2 class="text-2xl md:text-3xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($settings['heading']); ?></h2>
                        <?php if (!empty($settings['description'])) : ?>
                        <p class="text-[var(--text-secondary)] mb-8 max-w-xl mx-auto"><?php echo esc_html($settings['description']); ?></p>
                        <?php endif; ?>

                        <a href="<?php echo esc_url($settings['button_link']['url'] ?? '#'); ?>" class="inline-flex items-center justify-center gap-2 px-8 py-4 bg-[var(--primary)] text-[var(--text-on-primary)] rounded-lg font-semibold text-lg hover:opacity-90 transition-colors">
                            <?php echo esc_html($buttonText); ?>
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                        </a>
                    </div>
                </div>
            </section>
        </div>
        <?php
    }
}
