<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Categories_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_categories_minimal'; }
    public function get_title() { return __('Categories Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-folder'; }
    public function get_categories() { return array('ai-theme-categories'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('use_woocommerce', array('label' => __('Use WooCommerce Categories', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->add_control('count', array('label' => __('Count', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 8));
        $this->add_control('show_count', array('label' => __('Show Product Count', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        
        if ($settings['use_woocommerce'] === 'yes' && class_exists('WooCommerce')) {
            $categories = get_terms(array('taxonomy' => 'product_cat', 'hide_empty' => false, 'number' => intval($settings['count'])));
        } else {
            $categories = get_categories(array('number' => intval($settings['count'])));
        }
        ?>
        <section class="py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="categories" data-block-variant="categories-minimal">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['subheading'])) : ?>
                    <p class="text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($settings['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Categories Grid -->
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 md:gap-6">
                    <?php foreach ($categories as $cat) : 
                        $link = get_term_link($cat);
                        $thumb_id = get_term_meta($cat->term_id, 'thumbnail_id', true);
                        $image = $thumb_id ? wp_get_attachment_image_url($thumb_id, 'medium') : '';
                    ?>
                    <a href="<?php echo esc_url($link); ?>" class="group block">
                        <!-- Image -->
                        <div class="relative aspect-square rounded-lg overflow-hidden bg-[var(--bg-secondary)] mb-3">
                            <?php if ($image) : ?>
                            <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($cat->name); ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300" />
                            <?php else : ?>
                            <div class="w-full h-full flex items-center justify-center bg-[var(--bg-secondary)]">
                                <svg class="w-12 h-12 text-[var(--text-muted)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                </svg>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Hover overlay -->
                            <div class="absolute inset-0 bg-black/0 group-hover:bg-black/10 transition-colors duration-300"></div>
                        </div>

                        <!-- Info -->
                        <div class="flex items-start justify-between gap-2">
                            <div>
                                <h3 class="font-semibold text-[var(--text-primary)] group-hover:text-[var(--primary)] transition-colors"><?php echo esc_html($cat->name); ?></h3>
                                <?php if ($settings['show_count'] === 'yes') : ?>
                                <p class="text-sm text-[var(--text-muted)]"><?php echo $cat->count; ?> <?php _e('products', 'ai-theme'); ?></p>
                                <?php endif; ?>
                            </div>
                            <svg class="w-4 h-4 text-[var(--text-muted)] group-hover:text-[var(--primary)] group-hover:translate-x-1 transition-all flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </div>
                    </a>
                    <?php endforeach; ?>
                </div>

                <!-- Empty State -->
                <?php if (empty($categories)) : ?>
                <div class="text-center py-16">
                    <svg class="w-12 h-12 text-[var(--text-muted)] mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                    <p class="text-[var(--text-muted)]"><?php _e('No categories found', 'ai-theme'); ?></p>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
