<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Blog_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_blog_minimal'; }
    public function get_title() { return __('Blog Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-post-list'; }
    public function get_categories() { return array('ai-theme-blog'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('posts_count', array('label' => __('Posts Count', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 3, 'min' => 1, 'max' => 12));
        $this->add_control('show_date', array('label' => __('Show Date', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $args = array('post_type' => 'post', 'posts_per_page' => intval($settings['posts_count']), 'post_status' => 'publish');
        $posts = get_posts($args);
        ?>
        <section class="py-12 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="blog" data-block-variant="blog-minimal">
            <div class="max-w-3xl mx-auto px-6">
                <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-2xl font-bold text-[var(--text-primary)] mb-8"><?php echo esc_html($settings['heading']); ?></h2>
                <?php endif; ?>
                <div class="space-y-6">
                    <?php foreach ($posts as $post) : ?>
                        <article class="border-b border-[var(--border-color)] pb-6 last:border-0">
                            <a href="<?php echo get_permalink($post); ?>" class="block group">
                                <?php if ($settings['show_date'] === 'yes') : ?>
                                    <time class="text-sm text-[var(--text-muted)]"><?php echo get_the_date('', $post); ?></time>
                                <?php endif; ?>
                                <h3 class="text-lg font-bold text-[var(--text-primary)] group-hover:text-[var(--primary)] transition-colors mt-1"><?php echo esc_html($post->post_title); ?></h3>
                                <p class="text-[var(--text-secondary)] mt-2 line-clamp-2"><?php echo esc_html(wp_trim_words($post->post_excerpt ?: $post->post_content, 25)); ?></p>
                            </a>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
        wp_reset_postdata();
    }
}
