<?php
/**
 * Text Article Widget
 * Текст в стиле статьи с акцентной линией (200-400 слов)
 */

namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Text_Article extends AI_Widget_Base {
    public function get_name() { return 'ai_text_article'; }
    public function get_title() { return __('Text Article', 'ai-theme'); }
    public function get_icon() { return 'eicon-post-content'; }
    public function get_categories() { return array('ai-theme-text'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);
        $this->add_control('content', ['label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::WYSIWYG, 'default' => '']);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-16 md:py-20 section-secondary" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="text" data-block-variant="text-article">
            <div class="max-w-3xl mx-auto px-4 sm:px-6">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="mb-10">
                    <?php if (!empty($s['heading'])) : ?>
                        <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                        <p class="text-xl text-[var(--text-secondary)] mb-4"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                    <div class="w-16 h-1 bg-[var(--primary)]"></div>
                </div>
                <?php endif; ?>

                <?php if (!empty($s['content'])) : ?>
                <div class="space-y-5 text-[var(--text-secondary)] leading-relaxed text-lg">
                    <?php echo wp_kses_post($s['content']); ?>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
