<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Testimonials_Grid extends AI_Widget_Base {
    public function get_name() { return 'ai_testimonials_grid'; }
    public function get_title() { return __('Testimonials Grid', 'ai-theme'); }
    public function get_icon() { return 'eicon-testimonial'; }
    public function get_categories() { return array('ai-theme-testimonials'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('name', ['label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('position', ['label' => __('Position', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('content', ['label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('avatar', ['label' => __('Avatar', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('rating', ['label' => __('Rating', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'min' => 1, 'max' => 5, 'default' => 5]);
        $this->add_control('testimonials', ['label' => __('Testimonials', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $title = !empty($s['title']) ? $s['title'] : ai_get_text('blocks.testimonials.heading', '');
        $testimonials = !empty($s['testimonials']) ? $s['testimonials'] : [];
        
        if (empty($testimonials)) return;
        ?>
        <section class="ai-testimonials ai-testimonials-grid section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="testimonials" data-block-variant="testimonials-grid">
            <div class="max-w-7xl mx-auto px-6">
                <div class="text-center mb-12">
                    <h2 class="ai-testimonials-title text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($title); ?></h2>
                </div>
                <div class="ai-testimonials-items grid sm:grid-cols-2 md:grid-cols-4 gap-5">
                    <?php foreach ($testimonials as $t) : ?>
                    <div class="ai-testimonial-item bg-[var(--bg-primary)] p-5 rounded-xl shadow-sm hover:shadow-lg transition-all">
                        <?php $rating = $t['rating'] ?? 5; if ($rating > 0) : ?>
                        <div class="flex gap-0.5 mb-3">
                            <?php for ($i = 0; $i < 5; $i++) : ?>
                            <span class="text-base <?php echo $i < $rating ? 'opacity-100' : 'opacity-30'; ?>">⭐</span>
                            <?php endfor; ?>
                        </div>
                        <?php endif; ?>
                        <p class="text-sm text-[var(--text-secondary)] mb-4 leading-relaxed line-clamp-4">"<?php echo esc_html($t['content'] ?? ''); ?>"</p>
                        <div class="ai-testimonial-author flex items-center gap-2">
                            <?php if (!empty($t['avatar']['url'])) : ?>
                            <img src="<?php echo esc_url($t['avatar']['url']); ?>" alt="<?php echo esc_attr($t['name'] ?? ''); ?>" class="w-10 h-10 rounded-full object-cover">
                            <?php else : ?>
                            <div class="w-10 h-10 rounded-full flex items-center justify-center text-[var(--text-on-primary)] font-bold text-sm bg-[var(--primary)]">
                                <?php echo esc_html(mb_substr($t['name'] ?? 'U', 0, 1)); ?>
                            </div>
                            <?php endif; ?>
                            <div>
                                <strong class="font-semibold text-sm text-[var(--text-primary)]"><?php echo esc_html($t['name'] ?? ''); ?></strong>
                                <?php if (!empty($t['position'])) : ?>
                                <span class="text-xs text-[var(--text-secondary)] block"><?php echo esc_html($t['position']); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
