<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Testimonials_Cards extends AI_Widget_Base {
    public function get_name() { return 'ai_testimonials_cards'; }
    public function get_title() { return __('Testimonials Cards', 'ai-theme'); }
    public function get_icon() { return 'eicon-testimonial'; }
    public function get_categories() { return array('ai-theme-testimonials'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('name', ['label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('position', ['label' => __('Position', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('content', ['label' => __('Content', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('avatar', ['label' => __('Avatar', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $this->add_control('testimonials', ['label' => __('Testimonials', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $title = !empty($s['title']) ? $s['title'] : ai_get_text('blocks.testimonials.heading', '');
        $testimonials = !empty($s['testimonials']) ? $s['testimonials'] : [];
        
        if (empty($testimonials)) return;
        ?>
        <section class="ai-testimonials ai-testimonials-cards section-light py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="testimonials" data-block-variant="testimonials-cards">
            <div class="ai-container">
                <div class="text-center mb-12">
                    <h2 class="ai-testimonials-title text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($title); ?></h2>
                </div>
                <div class="ai-testimonials-items grid md:grid-cols-2 gap-8">
                    <?php foreach ($testimonials as $t) : ?>
                    <div class="ai-testimonial-card relative p-8 rounded-2xl border border-[var(--border-color,#e5e7eb)] bg-[var(--bg-secondary)]">
                        <svg class="absolute top-4 right-4 w-12 h-12 opacity-20 text-[var(--primary)]" fill="currentColor" viewBox="0 0 24 24"><path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z"/></svg>
                        <div class="text-[var(--text-primary)] text-lg mb-6 leading-relaxed prose prose-sm max-w-none">"<?php echo wp_kses_post($t['content'] ?? ''); ?>"</div>
                        <div class="ai-testimonial-author flex items-center gap-4">
                            <?php if (!empty($t['avatar']['url'])) : ?>
                                <img src="<?php echo esc_url($t['avatar']['url']); ?>" alt="" class="w-16 h-16 rounded-full border-4 border-[var(--bg-primary)] shadow-md object-cover">
                            <?php else : ?>
                                <div class="w-16 h-16 rounded-full border-4 border-[var(--bg-primary)] shadow-md flex items-center justify-center text-[var(--text-on-primary)] font-bold text-xl bg-[var(--primary)]">
                                    <?php echo esc_html(mb_substr($t['name'] ?? 'U', 0, 1)); ?>
                                </div>
                            <?php endif; ?>
                            <div>
                                <strong class="font-bold text-[var(--text-primary)] text-lg block"><?php echo esc_html($t['name'] ?? ''); ?></strong>
                                <span class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($t['position'] ?? ''); ?></span>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
