<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Team_V1 extends AI_Widget_Base {
    public function get_name() { return 'ai_team_v1'; }
    public function get_title() { return __('Team V1', 'ai-theme'); }
    public function get_icon() { return 'eicon-person'; }
    public function get_categories() { return array('ai-theme-team'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subtitle', ['label' => __('Subtitle', 'ai-theme'), 'type' => Controls_Manager::TEXT]);

        $repeater = new Repeater();
        $repeater->add_control('name', ['label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('position', ['label' => __('Position', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('image', ['label' => __('Photo', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('bio', ['label' => __('Bio', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('members', ['label' => __('Team Members', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-team ai-team-v1 section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="team" data-block-variant="team-v1">
            <div class="ai-container">
                <div class="ai-team-header text-center mb-12">
                    <?php if (!empty($s['subtitle'])) : ?>
                    <p class="ai-team-subtitle text-[var(--primary)] font-semibold mb-2"><?php echo esc_html($s['subtitle']); ?></p>
                    <?php endif; ?>
                    <h2 class="ai-team-title text-4xl font-bold text-[var(--text-primary)]"><?php echo esc_html($s['title']); ?></h2>
                </div>
                <div class="ai-team-members grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <?php foreach ($s['members'] as $index => $m) :
                        $initials = '';
                        $name_parts = explode(' ', $m['name']);
                        foreach ($name_parts as $part) {
                            if (!empty($part)) {
                                $initials .= strtoupper(substr($part, 0, 1));
                            }
                        }
                    ?>
                    <div class="ai-team-member bg-[var(--bg-primary)] rounded-2xl overflow-hidden shadow-sm hover:shadow-xl transition-all">
                        <div class="h-64 flex items-center justify-center relative overflow-hidden" style="background: linear-gradient(to bottom right, var(--primary), var(--secondary));">
                            <?php if (!empty($m['image']['url'])) : ?>
                            <img src="<?php echo esc_url($m['image']['url']); ?>" alt="<?php echo esc_attr($m['name']); ?>" class="w-full h-full object-cover">
                            <?php else : ?>
                            <div class="w-24 h-24 bg-white/30 backdrop-blur-sm rounded-full flex items-center justify-center">
                                <span class="text-white text-3xl font-bold"><?php echo esc_html($initials); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="p-6 text-center">
                            <h3 class="text-xl font-bold text-[var(--text-primary)] mb-1"><?php echo esc_html($m['name']); ?></h3>
                            <p class="ai-team-position text-[var(--text-secondary)] mb-4"><?php echo esc_html($m['position']); ?></p>
                            <?php if (!empty($m['bio'])) : ?>
                            <p class="text-sm text-[var(--text-muted)] mb-4"><?php echo esc_html($m['bio']); ?></p>
                            <?php endif; ?>
                            <div class="flex justify-center gap-3">
                                <button class="w-8 h-8 bg-[var(--bg-secondary)] rounded-lg flex items-center justify-center hover:bg-[var(--primary-light)] transition-colors">
                                    <span class="text-[var(--text-secondary)]">in</span>
                                </button>
                                <button class="w-8 h-8 bg-[var(--bg-secondary)] rounded-lg flex items-center justify-center hover:bg-[var(--primary-light)] transition-colors">
                                    <span class="text-[var(--text-secondary)]">𝕏</span>
                                </button>
                                <button class="w-8 h-8 bg-[var(--bg-secondary)] rounded-lg flex items-center justify-center hover:bg-[var(--primary-light)] transition-colors">
                                    <span class="text-[var(--text-secondary)]">✉</span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
