<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Shipping_Info extends AI_Widget_Base {
    public function get_name() { return 'ai_shipping_info'; }
    public function get_title() { return __('Shipping Info', 'ai-theme'); }
    public function get_icon() { return 'eicon-truck'; }
    public function get_categories() { return array('ai-theme-shipping'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('icon', ['label' => __('Icon', 'ai-theme'), 'type' => Controls_Manager::ICONS]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('items', ['label' => __('Items', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');

        $title = !empty($s['title']) ? $s['title'] : '';

        // Use provided items only - no hardcoded defaults
        $items = !empty($s['items']) ? $s['items'] : [];
        ?>
        <section class="w-full bg-[var(--bg-secondary)] py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="shipping" data-block-variant="shipping-info">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <?php if (!empty($title)) : ?>
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($title); ?></h2>
                </div>
                <?php endif; ?>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <?php foreach ($items as $idx => $item) : 
                        $colors = ['from-blue-500 to-blue-600', 'from-indigo-500 to-indigo-600', 'from-purple-500 to-purple-600', 'from-emerald-500 to-emerald-600'];
                        $color = $colors[$idx % count($colors)];
                    ?>
                    <div class="bg-[var(--bg-primary)] rounded-xl border border-[var(--border-color)] p-6 hover:shadow-lg transition-all hover:-translate-y-1">
                        <div class="flex items-start gap-4">
                            <?php
                            $iconValue = '';
                            if (!empty($item['icon']['value'])) {
                                $iconValue = $item['icon']['value'];
                            } elseif (!empty($item['icon']) && is_string($item['icon'])) {
                                $iconValue = $item['icon'];
                            }
                            ?>
                            <div class="flex-shrink-0 w-12 h-12 bg-gradient-to-br <?php echo $color; ?> rounded-xl flex items-center justify-center shadow-lg">
                                <?php if (!empty($iconValue)) : ?>
                                <i class="<?php echo esc_attr($iconValue); ?> text-xl text-white"></i>
                                <?php else : ?>
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path>
                                </svg>
                                <?php endif; ?>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-lg font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($item['title'] ?? ''); ?></h3>
                                <div class="text-[var(--text-secondary)] text-sm leading-relaxed"><?php echo wp_kses_post($item['description'] ?? ''); ?></div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
