<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Shipping_Cards extends AI_Widget_Base {
    public function get_name() { return 'ai_shipping_cards'; }
    public function get_title() { return __('Shipping Cards', 'ai-theme'); }
    public function get_icon() { return 'eicon-delivery'; }
    public function get_categories() { return array('ai-theme-shipping'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('free_shipping_from', array('label' => __('Free Shipping From', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 5000));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $repeater->add_control('price', array('label' => __('Price', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('time', array('label' => __('Delivery Time', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('features', array('label' => __('Features (one per line)', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));

        $this->add_control('options', array('label' => __('Options', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $free_from = intval($settings['free_shipping_from']);
        ?>
        <section class="py-16 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="shipping" data-block-variant="shipping-cards">
            <div class="max-w-6xl mx-auto px-4">
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-3xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['subheading'])) : ?>
                    <p class="text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($settings['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Free Shipping Banner -->
                <?php if ($free_from > 0) : ?>
                <div class="bg-gradient-to-r from-emerald-500 to-teal-600 text-white rounded-xl p-6 mb-8 flex items-center gap-4 shadow-lg">
                    <div class="w-14 h-14 bg-white/20 rounded-full flex items-center justify-center">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold"><?php _e('Free shipping', 'ai-theme'); ?></h3>
                        <p class="text-white/90"><?php printf(__('On orders from %s', 'ai-theme'), number_format($free_from, 0, ',', ' ')); ?></p>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Method Cards -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php foreach ($settings['options'] as $opt) : 
                        $features = !empty($opt['features']) ? array_filter(explode("\n", $opt['features'])) : [];
                    ?>
                    <div class="bg-[var(--bg-primary)] rounded-xl p-6 shadow-sm hover:shadow-lg transition-shadow">
                        <div class="flex items-start gap-4">
                            <div class="w-12 h-12 bg-[var(--primary-light,#dbeafe)] rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <div class="flex items-start justify-between mb-2">
                                    <h3 class="font-bold text-[var(--text-primary)]"><?php echo esc_html($opt['title']); ?></h3>
                                    <span class="text-lg font-bold text-[var(--primary)]"><?php echo esc_html($opt['price']); ?></span>
                                </div>
                                <?php if (!empty($opt['description'])) : ?>
                                <p class="text-sm text-[var(--text-secondary)] mb-3"><?php echo esc_html($opt['description']); ?></p>
                                <?php endif; ?>
                                
                                <?php if (!empty($opt['time'])) : ?>
                                <div class="flex items-center gap-1 text-sm text-[var(--text-muted)] mb-3">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <?php echo esc_html($opt['time']); ?>
                                </div>
                                <?php endif; ?>

                                <?php if (!empty($features)) : ?>
                                <ul class="space-y-1">
                                    <?php foreach ($features as $feature) : ?>
                                    <li class="flex items-center gap-2 text-sm text-[var(--text-secondary)]">
                                        <svg class="w-4 h-4 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                        </svg>
                                        <?php echo esc_html(trim($feature)); ?>
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
