<?php
/**
 * Reviews Minimal Widget
 *
 * @package AI_Theme
 */

namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Reviews Minimal Widget - Clean simple design
 */
class Reviews_Minimal extends AI_Widget_Base {

    public function get_name() {
        return 'ai_reviews_minimal';
    }

    public function get_title() {
        return __('Reviews Minimal', 'ai-theme');
    }

    public function get_icon() {
        return 'eicon-review';
    }

    public function get_categories() {
        return array('ai-theme-testimonials');
    }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));

        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));

        $repeater = new Repeater();
        $repeater->add_control('author', array('label' => __('Author', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => 'Customer'));
        $repeater->add_control('comment', array('label' => __('Comment', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => 'Great experience!'));
        $repeater->add_control('rating', array('label' => __('Rating', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'min' => 1, 'max' => 5, 'default' => 5));

        $this->add_control('reviews', array(
            'label' => __('Reviews', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => array(
                array('author' => 'Alex', 'comment' => 'Simple and effective. Exactly what I needed.', 'rating' => 5),
                array('author' => 'Maria', 'comment' => 'Clean design, great functionality.', 'rating' => 5),
            ),
        ));

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="reviews" data-block-variant="reviews-minimal">
            <div class="max-w-3xl mx-auto px-6">
                <div class="text-center mb-12">
                    <?php if (!empty($settings['heading'])) : ?>
                        <h2 class="text-2xl md:text-3xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['subheading'])) : ?>
                        <p class="text-[var(--text-secondary)]"><?php echo esc_html($settings['subheading']); ?></p>
                    <?php endif; ?>
                </div>

                <div class="space-y-8">
                    <?php foreach ($settings['reviews'] as $review) : ?>
                        <div class="border-b border-[var(--border-color)] pb-8 last:border-0">
                            <div class="flex items-center gap-1 mb-3">
                                <?php for ($i = 1; $i <= 5; $i++) : ?>
                                    <svg class="w-4 h-4 <?php echo $i <= $review['rating'] ? 'text-yellow-400 fill-yellow-400' : 'text-[var(--border-color)]'; ?>" viewBox="0 0 24 24"><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/></svg>
                                <?php endfor; ?>
                            </div>
                            <p class="text-[var(--text-primary)] leading-relaxed mb-4"><?php echo esc_html($review['comment']); ?></p>
                            <p class="text-sm text-[var(--text-secondary)]">— <?php echo esc_html($review['author']); ?></p>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
