<?php
/**
 * Reviews Masonry Widget
 * Masonry сетка отзывов с CSS columns
 */

namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) {
    exit;
}

class Reviews_Masonry extends AI_Widget_Base {

    public function get_name() {
        return 'ai_reviews_masonry';
    }

    public function get_title() {
        return __('Reviews Masonry', 'ai-theme');
    }

    public function get_icon() {
        return 'eicon-review';
    }

    public function get_categories() {
        return array('ai-theme-testimonials');
    }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));

        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('author', array('label' => __('Author', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('comment', array('label' => __('Comment', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $repeater->add_control('rating', array('label' => __('Rating', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'min' => 1, 'max' => 5, 'default' => 5));
        $repeater->add_control('avatar', array('label' => __('Avatar', 'ai-theme'), 'type' => Controls_Manager::MEDIA));
        $repeater->add_control('verified', array('label' => __('Verified Buyer', 'ai-theme'), 'type' => Controls_Manager::SWITCHER));

        $this->add_control('reviews', array(
            'label' => __('Reviews', 'ai-theme'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => array(),
        ));

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-16 section-secondary" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="reviews" data-block-variant="reviews-masonry">
            <div class="max-w-6xl mx-auto px-6">
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($settings['heading'])) : ?>
                        <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['subheading'])) : ?>
                        <p class="text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($settings['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Masonry Grid with CSS columns -->
                <div class="columns-1 md:columns-2 lg:columns-3 gap-6" style="column-fill: balance;">
                    <?php foreach ($settings['reviews'] as $review) : ?>
                        <div class="break-inside-avoid mb-6 bg-[var(--bg-primary)] rounded-xl p-6 border border-[var(--border-color,#e5e7eb)] hover:shadow-lg transition-shadow">
                            <!-- Quote icon -->
                            <svg class="w-8 h-8 text-[var(--primary)] opacity-20 mb-3" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z"/>
                            </svg>

                            <!-- Comment -->
                            <p class="text-[var(--text-secondary)] leading-relaxed mb-4"><?php echo esc_html($review['comment']); ?></p>

                            <!-- Rating -->
                            <div class="flex items-center gap-1 mb-4">
                                <?php for ($i = 1; $i <= 5; $i++) : ?>
                                    <svg class="w-4 h-4 <?php echo $i <= $review['rating'] ? 'text-yellow-400 fill-yellow-400' : 'text-[var(--text-muted)]'; ?>" viewBox="0 0 24 24">
                                        <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                                    </svg>
                                <?php endfor; ?>
                            </div>

                            <!-- Author -->
                            <div class="flex items-center gap-3 pt-4 border-t border-[var(--border-color,#e5e7eb)]">
                                <?php if (!empty($review['avatar']['url'])) : ?>
                                    <img src="<?php echo esc_url($review['avatar']['url']); ?>" alt="<?php echo esc_attr($review['author']); ?>" class="w-10 h-10 rounded-full object-cover" />
                                <?php else : ?>
                                    <div class="w-10 h-10 rounded-full flex items-center justify-center" style="background: linear-gradient(to bottom right, var(--primary), var(--secondary));">
                                        <span class="text-white font-semibold text-sm"><?php echo esc_html(mb_substr($review['author'], 0, 1)); ?></span>
                                    </div>
                                <?php endif; ?>
                                <div>
                                    <p class="font-semibold text-[var(--text-primary)] text-sm"><?php echo esc_html($review['author']); ?></p>
                                    <?php if (!empty($review['verified']) && $review['verified'] === 'yes') : ?>
                                        <p class="text-xs text-[var(--text-muted)]"><?php echo ai_get_text('reviews.verifiedBuyer', __('Verified Buyer', 'ai-theme')); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
