<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Newsletter_Split extends AI_Widget_Base {
    public function get_name() { return 'ai_newsletter_split'; }
    public function get_title() { return __('Newsletter Split', 'ai-theme'); }
    public function get_icon() { return 'eicon-email-field'; }
    public function get_categories() { return array('ai-theme-forms'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('placeholder', ['label' => __('Email Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('button_text', ['label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('benefit', ['label' => __('Benefit', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('benefits', ['label' => __('Benefits', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => []]);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $benefits = $s['benefits'] ?? [];
        ?>
        <section class="w-full section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="newsletter" data-block-variant="newsletter-split">
            <div class="max-w-7xl mx-auto px-6">
                <div class="bg-[var(--bg-primary)] rounded-2xl shadow-xl overflow-hidden">
                    <div class="grid grid-cols-1 lg:grid-cols-2">
                        <!-- Left - Info -->
                        <div class="p-8 md:p-12 bg-[var(--bg-secondary)]">
                            <div class="h-full flex flex-col justify-center">
                                <?php if (!empty($s['heading'])) : ?>
                                <h2 class="text-3xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($s['description'])) : ?>
                                <p class="text-lg text-[var(--text-secondary)] mb-8"><?php echo esc_html($s['description']); ?></p>
                                <?php endif; ?>

                                <?php if (!empty($benefits)) : ?>
                                <ul class="space-y-4">
                                    <?php foreach ($benefits as $item) : ?>
                                    <li class="flex items-start gap-3">
                                        <div class="flex-shrink-0 w-6 h-6 bg-[var(--primary)] rounded-full flex items-center justify-center">
                                            <svg class="w-4 h-4 text-[var(--text-on-primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                                        </div>
                                        <span class="text-[var(--text-primary)]"><?php echo esc_html($item['benefit']); ?></span>
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Right - Form -->
                        <div class="p-8 md:p-12 flex items-center">
                            <form class="w-full space-y-6">
                                <div class="relative">
                                    <svg class="absolute left-4 top-1/2 -translate-y-1/2 w-5 h-5 text-[var(--text-muted)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                                    <input type="email" placeholder="<?php echo esc_attr($s['placeholder']); ?>" class="w-full pl-12 pr-4 py-3 rounded-lg border border-[var(--border-color,#e5e7eb)] focus:outline-none focus:border-[var(--primary)] focus:ring-2 focus:ring-[var(--primary)]/20">
                                </div>
                                <button type="submit" class="w-full px-6 py-4 bg-[var(--primary)] hover:opacity-90 text-white rounded-lg font-semibold transition-colors flex items-center justify-center gap-2">
                                    <?php echo esc_html($s['button_text']); ?>
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
