<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Newsletter_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_newsletter_minimal'; }
    public function get_title() { return __('Newsletter Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-email-field'; }
    public function get_categories() { return array('ai-theme-forms'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('placeholder', ['label' => __('Email Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => 'your@email.com']);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="newsletter" data-block-variant="newsletter-minimal">
            <div class="max-w-xl mx-auto px-6 text-center">
                <?php if (!empty($s['heading'])) : ?>
                <h3 class="text-sm font-medium tracking-widest text-[var(--text-muted)] uppercase mb-6"><?php echo esc_html($s['heading']); ?></h3>
                <?php endif; ?>

                <form>
                    <div class="relative p-1 rounded-full border border-[var(--border-color)] focus-within:border-[var(--primary)] transition-all duration-300" style="background: linear-gradient(to right, var(--bg-secondary), var(--bg-secondary));">
                        <div class="flex bg-[var(--bg-primary)] rounded-full overflow-hidden">
                            <input type="email" placeholder="<?php echo esc_attr($s['placeholder']); ?>" class="flex-1 px-6 py-4 bg-transparent text-[var(--text-primary)] placeholder-[var(--text-muted)] focus:outline-none">
                            <button type="submit" class="m-1 px-6 py-3 text-white font-medium rounded-full transition-colors flex items-center gap-2" style="background: var(--text-primary);">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </section>
        <?php
    }
}
