<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Modal_Subscribe extends AI_Widget_Base {
    public function get_name() { return 'ai_modal_subscribe'; }
    public function get_title() { return __('Modal Subscribe', 'ai-theme'); }
    public function get_icon() { return 'eicon-email-field'; }
    public function get_categories() { return array('ai-theme-modal'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('button_text', ['label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('modal_title', ['label' => __('Modal Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('modal_description', ['label' => __('Modal Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('email_placeholder', ['label' => __('Email Placeholder', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('submit_text', ['label' => __('Submit Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $id = 'ai-modal-' . $this->get_id();
        ?>
        <div class="ai-modal-trigger" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="modal" data-block-variant="modal-subscribe">
            <button class="ai-modal-open text-white px-6 py-3 rounded-lg hover:opacity-90 transition-all font-medium" style="background: linear-gradient(to right, var(--primary), var(--secondary));" data-modal="<?php echo esc_attr($id); ?>"><?php echo esc_html($s['button_text']); ?></button>
        </div>
        <div class="ai-modal fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm" id="<?php echo esc_attr($id); ?>">
            <div class="ai-modal-content ai-modal-subscribe max-w-md w-full rounded-2xl shadow-2xl overflow-hidden relative">
                <button class="ai-modal-close absolute top-4 right-4 text-white hover:text-white/80 transition-colors z-10 text-2xl">&times;</button>
                <div class="p-8 text-white" style="background: linear-gradient(to bottom right, var(--primary), var(--secondary));">
                    <h3 class="text-3xl font-bold mb-2"><?php echo esc_html($s['modal_title']); ?></h3>
                    <?php if (!empty($s['modal_description'])) : ?>
                    <p class="text-white/80 mb-6"><?php echo esc_html($s['modal_description']); ?></p>
                    <?php endif; ?>
                    <form class="ai-modal-form space-y-4">
                        <div>
                            <input type="email" placeholder="<?php echo esc_attr($s['email_placeholder']); ?>" required class="w-full px-4 py-3 rounded-lg border-0 bg-white/95 text-[var(--text-primary)] placeholder-[var(--text-muted)] focus:ring-2 focus:ring-white focus:outline-none">
                        </div>
                        <button type="submit" class="w-full bg-white text-[var(--primary)] py-3 rounded-lg hover:bg-white/90 transition-colors font-medium"><?php echo esc_html($s['submit_text']); ?></button>
                    </form>
                </div>
            </div>
        </div>
        <?php
    }
}
