<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Map_Card extends AI_Widget_Base {
    public function get_name() { return 'ai_map_card'; }
    public function get_title() { return __('Map Card', 'ai-theme'); }
    public function get_icon() { return 'eicon-google-maps'; }
    public function get_categories() { return array('ai-theme-contact'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('embed_url', ['label' => __('Google Maps Embed URL', 'ai-theme'), 'type' => Controls_Manager::URL]);
        $this->add_control('address', ['label' => __('Address', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('phone', ['label' => __('Phone', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('email', ['label' => __('Email', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('working_hours', ['label' => __('Working Hours (one per line)', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $hours = !empty($s['working_hours']) ? array_filter(explode("\n", $s['working_hours'])) : [];
        ?>
        <section class="py-16 section-secondary" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="map" data-block-variant="map-card">
            <div class="max-w-4xl mx-auto px-4">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-8">
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-3xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-[var(--text-secondary)]"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <div class="bg-[var(--bg-primary)] rounded-2xl shadow-lg overflow-hidden">
                    <!-- Map -->
                    <?php if (!empty($s['embed_url']['url'])) : ?>
                    <iframe src="<?php echo esc_url($s['embed_url']['url']); ?>" width="100%" height="250" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    <?php endif; ?>

                    <!-- Contact Info -->
                    <div class="p-6 grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <?php if (!empty($s['address'])) : ?>
                        <div class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[var(--primary)] mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                            <span class="text-[var(--text-secondary)] text-sm"><?php echo nl2br(esc_html($s['address'])); ?></span>
                        </div>
                        <?php endif; ?>

                        <?php if (!empty($s['phone'])) : ?>
                        <a href="tel:<?php echo esc_attr($s['phone']); ?>" class="flex items-center gap-3 hover:text-[var(--primary)]">
                            <svg class="w-5 h-5 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                            <span class="text-[var(--text-secondary)] text-sm"><?php echo esc_html($s['phone']); ?></span>
                        </a>
                        <?php endif; ?>

                        <?php if (!empty($s['email'])) : ?>
                        <a href="mailto:<?php echo esc_attr($s['email']); ?>" class="flex items-center gap-3 hover:text-[var(--primary)]">
                            <svg class="w-5 h-5 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                            <span class="text-[var(--text-secondary)] text-sm"><?php echo esc_html($s['email']); ?></span>
                        </a>
                        <?php endif; ?>

                        <?php if (!empty($hours)) : ?>
                        <div class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[var(--primary)] mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                            <div class="text-[var(--text-secondary)] text-sm">
                                <?php foreach ($hours as $h) : ?>
                                <div><?php echo esc_html(trim($h)); ?></div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
