<?php
/**
 * Hero Dark Widget
 *
 * @package AI_Theme
 */

namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Hero Dark Widget - Dark minimalist hero
 */
class Hero_Dark extends AI_Widget_Base {

    public function get_name() {
        return 'ai_hero_dark';
    }

    public function get_title() {
        return __('Hero Dark', 'ai-theme');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return array('ai-theme-hero', 'ai-theme-blocks');
    }

    public function get_keywords() {
        return array('hero', 'banner', 'dark', 'minimal', 'ai', 'landing');
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'ai-theme'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'eyebrow',
            array(
                'label'   => __('Eyebrow Text', 'ai-theme'),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            )
        );

        $this->add_control(
            'heading',
            array(
                'label'       => __('Heading', 'ai-theme'),
                'type'        => Controls_Manager::TEXT,
                'default'     => '',
                'label_block' => true,
            )
        );

        $this->add_control(
            'subheading',
            array(
                'label'   => __('Subheading', 'ai-theme'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => '',
                'rows'    => 3,
            )
        );

        $this->add_control(
            'cta_text',
            array(
                'label'   => __('Button Text', 'ai-theme'),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            )
        );

        $this->add_control(
            'cta_link',
            array(
                'label'   => __('Button Link', 'ai-theme'),
                'type'    => Controls_Manager::URL,
                'default' => array('url' => '#'),
            )
        );

        $this->end_controls_section();

        // Layout
        $this->start_controls_section(
            'layout_section',
            array(
                'label' => __('Layout', 'ai-theme'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_theme_style_control();

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $theme = $settings['theme_style'] ?? 'inherit';
        if ($theme === 'inherit') {
            $theme = get_option('ai_theme_style', 'modern');
        }
        ?>
        <div data-theme="<?php echo esc_attr($theme); ?>" class="ai-theme-block">
            <section
                class="ai-hero ai-hero-dark relative min-h-screen flex items-center justify-center section-light overflow-hidden"
                data-block-type="hero"
                data-block-variant="hero-dark"
            >
                <!-- Subtle gradient accents -->
                <div class="absolute inset-0 overflow-hidden pointer-events-none">
                    <div class="absolute top-0 left-1/4 w-96 h-96 rounded-full blur-3xl" style="background-color: rgba(var(--primary-rgb, 59, 130, 246), 0.1);"></div>
                    <div class="absolute bottom-0 right-1/4 w-96 h-96 rounded-full blur-3xl" style="background-color: rgba(var(--secondary-rgb, 139, 92, 246), 0.1);"></div>
                </div>

                <!-- Grid pattern -->
                <div class="absolute inset-0 opacity-[0.03]" style="background-image: linear-gradient(rgba(255,255,255,0.1) 1px, transparent 1px), linear-gradient(90deg, rgba(255,255,255,0.1) 1px, transparent 1px); background-size: 60px 60px;"></div>

                <!-- Content -->
                <div class="relative z-10 max-w-4xl mx-auto px-6 md:px-8 text-center">
                    <!-- Eyebrow -->
                    <?php if (!empty($settings['eyebrow'])) : ?>
                        <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-[var(--primary)]/10 border border-[var(--border-color)] mb-8">
                            <span class="w-2 h-2 rounded-full bg-[var(--primary)] animate-pulse"></span>
                            <span class="text-sm font-medium text-[var(--text-secondary)]"><?php echo esc_html($settings['eyebrow']); ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($settings['heading'])) : ?>
                        <h1 class="ai-hero-heading text-4xl md:text-5xl lg:text-6xl xl:text-7xl font-bold text-[var(--text-primary)] leading-tight mb-6">
                            <?php echo esc_html($settings['heading']); ?>
                        </h1>
                    <?php endif; ?>

                    <!-- Accent line -->
                    <div class="flex justify-center mb-8">
                        <div class="w-24 h-1 rounded-full" style="background: linear-gradient(to right, var(--primary), var(--secondary));"></div>
                    </div>

                    <?php if (!empty($settings['subheading'])) : ?>
                        <p class="ai-hero-subheading text-lg md:text-xl text-[var(--text-muted)] max-w-2xl mx-auto mb-10">
                            <?php echo esc_html($settings['subheading']); ?>
                        </p>
                    <?php endif; ?>

                    <!-- CTA Button -->
                    <?php if (!empty($settings['cta_text'])) : ?>
                        <div class="flex items-center justify-center">
                            <a
                                href="<?php echo esc_url($settings['cta_link']['url'] ?? '#'); ?>"
                                class="px-8 py-4 bg-[var(--bg-primary)] text-[var(--text-primary)] font-semibold rounded-lg hover:opacity-90 transition-all duration-300"
                                <?php echo !empty($settings['cta_link']['is_external']) ? 'target="_blank"' : ''; ?>
                            >
                                <?php echo esc_html($settings['cta_text']); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </section>
        </div>
        <?php
    }
}
