<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Features_Grid extends AI_Widget_Base {
    public function get_name() { return 'ai_features_grid'; }
    public function get_title() { return __('Features Grid', 'ai-theme'); }
    public function get_icon() { return 'eicon-gallery-grid'; }
    public function get_categories() { return array('ai-theme-features'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subtitle', ['label' => __('Subtitle', 'ai-theme'), 'type' => Controls_Manager::TEXT]);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('icon', ['label' => __('Icon', 'ai-theme'), 'type' => Controls_Manager::ICONS]);
        $this->add_control('features', ['label' => __('Features', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-features ai-features-grid py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="features" data-block-variant="features-grid">
            <div class="ai-container">
                <div class="text-center mb-12">
                    <?php if (!empty($s['subtitle'])) : ?><p class="text-lg mb-4"><?php echo esc_html($s['subtitle']); ?></p><?php endif; ?>
                    <h2 class="text-4xl font-bold mb-4"><?php echo esc_html($s['title']); ?></h2>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <?php foreach ($s['features'] as $f) : ?>
                    <div class="ai-feature-item flex gap-4 p-6 rounded-lg shadow-sm border border-[var(--border-color,#e5e7eb)]">
                        <div class="flex-shrink-0">
                            <?php if (!empty($f['icon']['value'])) : ?>
                            <div class="w-12 h-12 rounded-lg flex items-center justify-center" style="background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);">
                                <i class="<?php echo esc_attr($f['icon']['value']); ?> text-white text-xl"></i>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold text-[var(--text-primary)] mb-2"><?php echo esc_html($f['title']); ?></h3>
                            <div class="text-[var(--text-secondary)] prose prose-sm max-w-none"><?php echo wp_kses_post($f['description']); ?></div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
