<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class FAQ_Minimal extends AI_Widget_Base {
    public function get_name() { return 'ai_faq_minimal'; }
    public function get_title() { return __('FAQ Minimal', 'ai-theme'); }
    public function get_icon() { return 'eicon-help-o'; }
    public function get_categories() { return array('ai-theme-faq'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);

        $repeater = new Repeater();
        $repeater->add_control('question', ['label' => __('Question', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('answer', ['label' => __('Answer', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('faqs', ['label' => __('FAQ Items', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-faq ai-faq-minimal section-light py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="faq" data-block-variant="faq-minimal">
            <div class="ai-container-narrow">
                <?php if (!empty($s['title'])) : ?>
                <div class="text-center mb-12">
                    <h2 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['title']); ?></h2>
                </div>
                <?php endif; ?>
                <div class="space-y-8">
                    <?php foreach ($s['faqs'] as $f) : ?>
                    <div class="ai-faq-item">
                        <h3 class="font-bold text-[var(--text-primary)] text-xl mb-3"><?php echo esc_html($f['question']); ?></h3>
                        <div class="text-[var(--text-secondary)] leading-relaxed border-l-4 border-[var(--primary)] pl-4 prose prose-sm max-w-none"><?php echo wp_kses_post($f['answer']); ?></div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
