<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class CTA_Split extends AI_Widget_Base {
    public function get_name() { return 'ai_cta_split'; }
    public function get_title() { return __('CTA Dark', 'ai-theme'); }
    public function get_icon() { return 'eicon-call-to-action'; }
    public function get_categories() { return array('ai-theme-cta'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $this->add_control('button_text', array('label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('button_link', array('label' => __('Button Link', 'ai-theme'), 'type' => Controls_Manager::URL));
        $this->add_control('secondary_button_text', array('label' => __('Secondary Button', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('secondary_button_link', array('label' => __('Secondary Link', 'ai-theme'), 'type' => Controls_Manager::URL));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $buttonText = !empty($settings['button_text']) ? $settings['button_text'] : ai_get_text('cta.buttonText', '');
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <div data-theme="<?php echo esc_attr($theme); ?>" class="ai-theme-block">
            <section class="py-20 section-secondary" data-block-type="cta" data-block-variant="cta-split">
                <div class="max-w-5xl mx-auto px-6 text-center">
                    <h2 class="text-3xl md:text-5xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php if (!empty($settings['description'])) : ?>
                    <p class="text-lg text-[var(--text-secondary)] mb-10 max-w-2xl mx-auto"><?php echo esc_html($settings['description']); ?></p>
                    <?php endif; ?>

                    <?php if (!empty($buttonText)) : ?>
                    <a href="<?php echo esc_url($settings['button_link']['url'] ?? '#'); ?>" class="inline-flex items-center justify-center gap-2 px-8 py-4 bg-[var(--primary)] text-[var(--text-on-primary)] rounded-lg font-semibold text-lg hover:opacity-90 transition-colors">
                        <?php echo esc_html($buttonText); ?>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                    </a>
                    <?php endif; ?>
                </div>
            </section>
        </div>
        <?php
    }
}
