<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class CTA_Banner extends AI_Widget_Base {
    public function get_name() { return 'ai_cta_banner'; }
    public function get_title() { return __('CTA Banner', 'ai-theme'); }
    public function get_icon() { return 'eicon-call-to-action'; }
    public function get_categories() { return array('ai-theme-cta'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('button_text', ['label' => __('Button Text', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('button_link', ['label' => __('Button Link', 'ai-theme'), 'type' => Controls_Manager::URL]);
        $this->add_control('background_image', ['label' => __('Background Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $buttonText = !empty($s['button_text']) ? $s['button_text'] : ai_get_text('cta.buttonText', '');
        $title = !empty($s['title']) ? $s['title'] : ai_get_text('blocks.cta.heading', '');
        $description = !empty($s['description']) ? $s['description'] : '';
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <div data-theme="<?php echo esc_attr($theme); ?>" class="ai-theme-block">
            <section class="py-16 bg-[var(--bg-secondary)]" data-block-type="cta" data-block-variant="cta-banner">
                <div class="max-w-4xl mx-auto px-6 text-center">
                    <?php if (!empty($title)) : ?>
                    <h2 class="cta-heading text-3xl md:text-4xl mb-4 text-[var(--text-primary)]"><?php echo esc_html($title); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($description)) : ?>
                    <p class="cta-description text-lg mb-8 max-w-2xl mx-auto text-[var(--text-secondary)]"><?php echo esc_html($description); ?></p>
                    <?php endif; ?>
                    <a href="<?php echo esc_url($s['button_link']['url'] ?? '#'); ?>" class="inline-flex items-center gap-2 px-8 py-4 bg-[var(--primary)] text-[var(--text-on-primary)] rounded-full font-semibold text-lg hover:opacity-90 transition-colors shadow-lg">
                        <?php echo esc_html($buttonText); ?>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/></svg>
                    </a>
                </div>
            </section>
        </div>
        <?php
    }
}
