<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cookies_Cards extends AI_Widget_Base {
    public function get_name() { return 'ai_cookies_cards'; }
    public function get_title() { return __('Cookies Cards', 'ai-theme'); }
    public function get_icon() { return 'eicon-info-circle'; }
    public function get_categories() { return array('ai-theme-cookies'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $this->add_control('last_updated', array('label' => __('Last Updated', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('contact_email', array('label' => __('Contact Email', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => ''));
        $repeater->add_control('required', array('label' => __('Required', 'ai-theme'), 'type' => Controls_Manager::SWITCHER));

        $this->add_control('cookies', array('label' => __('Cookie Types', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');

        // Use AI-generated texts with fallbacks
        $t = [
            'updated' => ai_get_text('legal.cookies.lastUpdated', 'Updated'),
            'required' => ai_get_text('common.required', 'Required'),
            'optional' => ai_get_text('common.optional', 'Optional'),
            'contactTitle' => ai_get_text('legal.cookies.contactTitle', 'Questions about cookie policy?'),
            'contactButton' => ai_get_text('legal.cookies.contactButton', 'Contact Us'),
        ];

        $colors = ['from-amber-500 to-orange-500', 'from-blue-500 to-blue-600', 'from-purple-500 to-purple-600', 'from-green-500 to-green-600', 'from-pink-500 to-pink-600', 'from-indigo-500 to-indigo-600'];
        $icons = [
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>',
            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>',
        ];
        ?>
        <section class="py-16 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cookies" data-block-variant="cookies-cards">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <div class="text-center mb-12">
                    <div class="w-16 h-16 bg-gradient-to-br from-amber-400 to-orange-500 rounded-2xl flex items-center justify-center mx-auto mb-6 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h1 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h1>
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($s['last_updated'])) : ?>
                    <p class="text-sm text-[var(--text-muted)] mt-2"><?php echo esc_html($t['updated']); ?>: <?php echo esc_html($s['last_updated']); ?></p>
                    <?php endif; ?>
                </div>

                <!-- Cards Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php foreach ($s['cookies'] as $idx => $cookie) : 
                        $color = $colors[$idx % count($colors)];
                        $icon = $icons[$idx % count($icons)];
                        $is_required = !empty($cookie['required']) && $cookie['required'] === 'yes';
                    ?>
                    <div class="bg-[var(--bg-primary)] rounded-2xl p-6 shadow-sm hover:shadow-lg transition-shadow border border-[var(--border-color)]">
                        <div class="flex items-start gap-4">
                            <div class="w-12 h-12 bg-gradient-to-br <?php echo $color; ?> rounded-xl flex items-center justify-center flex-shrink-0 shadow-lg">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><?php echo $icon; ?></svg>
                            </div>
                            <div class="flex-1 min-w-0">
                                <div class="flex items-start justify-between gap-2 mb-2">
                                    <h3 class="font-bold text-[var(--text-primary)]"><?php echo esc_html($cookie['title']); ?></h3>
                                    <span class="text-xs px-2 py-1 rounded-full font-medium flex-shrink-0 <?php echo $is_required ? 'bg-[var(--bg-secondary)] text-[var(--text-secondary)]' : 'bg-green-100 text-green-700'; ?>">
                                        <?php echo esc_html($is_required ? $t['required'] : $t['optional']); ?>
                                    </span>
                                </div>
                                <p class="text-sm text-[var(--text-secondary)] line-clamp-3"><?php echo esc_html($cookie['description']); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Contact -->
                <?php if (!empty($s['contact_email'])) : ?>
                <div class="mt-12 text-center">
                    <p class="text-[var(--text-secondary)] mb-3"><?php echo esc_html($t['contactTitle']); ?></p>
                    <a href="mailto:<?php echo esc_attr($s['contact_email']); ?>" class="inline-flex items-center gap-2 bg-gradient-to-r from-amber-500 to-orange-500 text-white px-6 py-3 rounded-xl font-semibold hover:from-amber-600 hover:to-orange-600 transition-all shadow-lg">
                        <?php echo esc_html($t['contactButton']); ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
