<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Contact_Form_Left extends AI_Widget_Base {
    public function get_name() { return 'ai_contact_form_left'; }
    public function get_title() { return __('Contact Form Left', 'ai-theme'); }
    public function get_icon() { return 'eicon-form-horizontal'; }
    public function get_categories() { return array('ai-theme-contact'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('phone', ['label' => __('Phone', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('email', ['label' => __('Email', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('address', ['label' => __('Address', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        
        // Labels from siteTexts (paths aligned with React components)
        $labels = [
            'name' => ai_get_text('forms.labels.name', ''),
            'email' => ai_get_text('forms.labels.email', 'Email'),
            'message' => ai_get_text('forms.labels.message', ''),
            'send' => ai_get_text('forms.buttons.send', ''),
            'phone' => ai_get_text('forms.labels.phone', ''),
            'address' => ai_get_text('forms.labels.address', ''),
            'contactInfo' => ai_get_text('blocks.contact.infoTitle', ''),
            'sendMsg' => ai_get_text('blocks.contact.formTitle', ''),
            'privacy' => ai_get_text('modals.contact.consentText', ''),
            'privacyLink' => ai_get_text('legal.privacy.title', '')
        ];
        
        $inputClass = "w-full px-4 py-3 bg-[var(--bg-secondary)] border border-[var(--border-color,#e5e7eb)] rounded-lg text-[var(--text-primary)] placeholder-[var(--text-muted)] focus:outline-none focus:ring-2 focus:ring-[var(--primary)] focus:border-transparent transition-all";
        ?>
        <section class="py-20 section-light" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="contact" data-block-variant="contact-form-left">
            <div class="max-w-6xl mx-auto px-6">
                <!-- Header -->
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-3"><?php echo esc_html($s['title']); ?></h2>
                    <?php if (!empty($s['description'])) : ?>
                    <p class="text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($s['description']); ?></p>
                    <?php endif; ?>
                </div>

                <div class="grid lg:grid-cols-2 gap-10">
                    <!-- Left - Contact Info -->
                    <div class="bg-[var(--bg-secondary)] border border-[var(--border-color)] rounded-2xl p-8">
                        <h3 class="text-2xl font-bold mb-8 text-[var(--text-primary)]"><?php echo esc_html($labels['contactInfo']); ?></h3>

                        <div class="space-y-6">
                            <?php if (!empty($s['email'])) : ?>
                            <a href="mailto:<?php echo esc_attr($s['email']); ?>" class="flex items-center gap-4 group">
                                <div class="w-12 h-12 bg-[var(--primary)] rounded-xl flex items-center justify-center group-hover:opacity-90 transition-colors">
                                    <svg class="w-5 h-5 text-[var(--text-on-primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                                </div>
                                <div>
                                    <p class="text-[var(--text-muted)] text-sm">Email</p>
                                    <p class="font-medium text-[var(--text-primary)]"><?php echo esc_html($s['email']); ?></p>
                                </div>
                            </a>
                            <?php endif; ?>

                            <?php if (!empty($s['phone'])) : ?>
                            <a href="tel:<?php echo esc_attr($s['phone']); ?>" class="flex items-center gap-4 group">
                                <div class="w-12 h-12 bg-[var(--primary)] rounded-xl flex items-center justify-center group-hover:opacity-90 transition-colors">
                                    <svg class="w-5 h-5 text-[var(--text-on-primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                                </div>
                                <div>
                                    <p class="text-[var(--text-muted)] text-sm"><?php echo esc_html($labels['phone']); ?></p>
                                    <p class="font-medium text-[var(--text-primary)]"><?php echo esc_html($s['phone']); ?></p>
                                </div>
                            </a>
                            <?php endif; ?>

                            <?php if (!empty($s['address'])) : ?>
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 bg-[var(--primary)] rounded-xl flex items-center justify-center">
                                    <svg class="w-5 h-5 text-[var(--text-on-primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                                </div>
                                <div>
                                    <p class="text-[var(--text-muted)] text-sm"><?php echo esc_html($labels['address']); ?></p>
                                    <p class="font-medium text-[var(--text-primary)]"><?php echo esc_html($s['address']); ?></p>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Right - Form -->
                    <div class="bg-[var(--bg-primary)] rounded-2xl shadow-lg border border-[var(--border-color,#e5e7eb)] p-8">
                        <h3 class="text-xl font-bold text-[var(--text-primary)] mb-6"><?php echo esc_html($labels['sendMsg']); ?></h3>

                        <form class="space-y-5">
                            <div>
                                <label class="block text-sm font-medium text-[var(--text-secondary)] mb-2">
                                    <?php echo esc_html($labels['name']); ?> <span class="text-red-500">*</span>
                                </label>
                                <input type="text" class="<?php echo esc_attr($inputClass); ?>" required />
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-[var(--text-secondary)] mb-2">
                                    <?php echo esc_html($labels['email']); ?> <span class="text-red-500">*</span>
                                </label>
                                <input type="email" class="<?php echo esc_attr($inputClass); ?>" required />
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-[var(--text-secondary)] mb-2">
                                    <?php echo esc_html($labels['message']); ?> <span class="text-red-500">*</span>
                                </label>
                                <textarea rows="4" class="<?php echo esc_attr($inputClass); ?> resize-none" required></textarea>
                            </div>

                            <!-- Privacy Checkbox -->
                            <div class="flex items-start gap-3 p-4 bg-[var(--bg-secondary)] rounded-lg">
                                <input type="checkbox" id="privacy-form-left-<?php echo esc_attr($this->get_id()); ?>" class="mt-0.5 w-4 h-4 text-[var(--primary)] border-[var(--border-color)] rounded focus:ring-[var(--primary)] cursor-pointer" />
                                <label for="privacy-form-left-<?php echo esc_attr($this->get_id()); ?>" class="text-sm text-[var(--text-secondary)] cursor-pointer">
                                    <?php echo esc_html($labels['privacy']); ?>
                                    <a href="/privacy-policy" target="_blank" rel="noopener noreferrer" class="text-[var(--primary)] hover:opacity-80 underline"><?php echo esc_html($labels['privacyLink']); ?></a>
                                    <span class="text-red-500 ml-1">*</span>
                                </label>
                            </div>

                            <button type="submit" class="w-full flex items-center justify-center gap-2 px-6 py-4 bg-[var(--primary)] text-white font-semibold rounded-lg hover:opacity-90 transition-colors">
                                <?php echo esc_html($labels['send']); ?>
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/></svg>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
