<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Categories_Featured extends AI_Widget_Base {
    public function get_name() { return 'ai_categories_featured'; }
    public function get_title() { return __('Categories Featured', 'ai-theme'); }
    public function get_icon() { return 'eicon-folder'; }
    public function get_categories() { return array('ai-theme-categories'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('use_woocommerce', array('label' => __('Use WooCommerce Categories', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->add_control('count', array('label' => __('Count', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 5));
        $this->add_control('show_count', array('label' => __('Show Product Count', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        
        if ($settings['use_woocommerce'] === 'yes' && class_exists('WooCommerce')) {
            $categories = get_terms(array('taxonomy' => 'product_cat', 'hide_empty' => false, 'number' => intval($settings['count'])));
        } else {
            $categories = get_categories(array('number' => intval($settings['count'])));
        }

        if (empty($categories)) {
            ?>
            <section class="py-16 md:py-24 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="categories" data-block-variant="categories-featured">
                <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center py-20">
                    <svg class="w-16 h-16 text-[var(--text-muted)] mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                    <p class="text-[var(--text-muted)]"><?php _e('No categories found', 'ai-theme'); ?></p>
                </div>
            </section>
            <?php
            return;
        }

        $featured = array_shift($categories);
        $others = array_slice($categories, 0, 4);
        $featured_thumb_id = get_term_meta($featured->term_id, 'thumbnail_id', true);
        $featured_image = $featured_thumb_id ? wp_get_attachment_image_url($featured_thumb_id, 'large') : '';
        $featured_description = $featured->description ?? '';
        ?>
        <section class="py-16 md:py-24 bg-[var(--bg-secondary)]" data-block-type="categories" data-block-variant="categories-featured">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                <div class="flex flex-col md:flex-row md:items-end md:justify-between gap-4 mb-12">
                    <div>
                        <?php if (!empty($settings['subheading'])) : ?>
                        <p class="text-sm font-medium text-[var(--primary)] mb-2"><?php echo esc_html($settings['subheading']); ?></p>
                        <?php endif; ?>
                        <?php if (!empty($settings['heading'])) : ?>
                        <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)]"><?php echo esc_html($settings['heading']); ?></h2>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- Featured Category - Large Card -->
                    <a href="<?php echo esc_url(get_term_link($featured)); ?>" class="group relative h-[400px] lg:h-full lg:min-h-[500px] rounded-3xl overflow-hidden">
                        <!-- Background -->
                        <div class="absolute inset-0 bg-[var(--bg-dark)]">
                            <?php if ($featured_image) : ?>
                            <img src="<?php echo esc_url($featured_image); ?>" alt="<?php echo esc_attr($featured->name); ?>" class="w-full h-full object-cover opacity-70 group-hover:opacity-80 group-hover:scale-105 transition-all duration-700" />
                            <?php endif; ?>
                            <div class="absolute inset-0 bg-gradient-to-t from-[var(--bg-dark)] via-[var(--bg-dark)]/60 to-transparent"></div>
                        </div>

                        <!-- Content -->
                        <div class="absolute inset-0 p-8 flex flex-col justify-end">
                            <div class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/20 backdrop-blur-sm w-fit mb-4">
                                <svg class="w-4 h-4 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"></path>
                                </svg>
                                <span class="text-sm font-medium text-white"><?php _e('Featured', 'ai-theme'); ?></span>
                            </div>

                            <h3 class="text-3xl md:text-4xl font-bold text-white mb-3"><?php echo esc_html($featured->name); ?></h3>

                            <?php if ($featured_description) : ?>
                            <p class="text-white/80 text-lg mb-6 max-w-md"><?php echo esc_html($featured_description); ?></p>
                            <?php endif; ?>

                            <div class="flex items-center justify-between">
                                <?php if ($settings['show_count'] === 'yes') : ?>
                                <span class="text-white/60"><?php echo $featured->count; ?> <?php _e('products', 'ai-theme'); ?></span>
                                <?php endif; ?>
                                <div class="flex items-center gap-2 text-white font-medium group-hover:gap-3 transition-all">
                                    <span><?php _e('View', 'ai-theme'); ?></span>
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </a>

                    <!-- Other Categories - 2x2 Grid -->
                    <div class="grid grid-cols-2 gap-4">
                        <?php foreach ($others as $cat) : 
                            $thumb_id = get_term_meta($cat->term_id, 'thumbnail_id', true);
                            $image = $thumb_id ? wp_get_attachment_image_url($thumb_id, 'medium') : '';
                        ?>
                        <a href="<?php echo esc_url(get_term_link($cat)); ?>" class="group relative h-60 rounded-2xl overflow-hidden bg-[var(--bg-secondary)]">
                            <!-- Background -->
                            <?php if ($image) : ?>
                            <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($cat->name); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" />
                            <?php else : ?>
                            <div class="w-full h-full bg-gradient-to-br from-[var(--bg-secondary)] to-[var(--bg-dark)]"></div>
                            <?php endif; ?>
                            <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-black/20 to-transparent"></div>

                            <!-- Content -->
                            <div class="absolute inset-0 p-5 flex flex-col justify-end">
                                <h3 class="text-lg font-bold text-white mb-1"><?php echo esc_html($cat->name); ?></h3>
                                <?php if ($settings['show_count'] === 'yes') : ?>
                                <p class="text-white/60 text-sm"><?php echo $cat->count; ?> <?php _e('products', 'ai-theme'); ?></p>
                                <?php endif; ?>
                            </div>

                            <!-- Hover Arrow -->
                            <div class="absolute top-4 right-4 w-8 h-8 rounded-full bg-transparent flex items-center justify-center opacity-0 group-hover:opacity-100 group-hover:bg-white transition-all duration-300">
                                <svg class="w-4 h-4 text-[var(--text-primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </div>
                        </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
