<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Categories_Compact extends AI_Widget_Base {
    public function get_name() { return 'ai_categories_compact'; }
    public function get_title() { return __('Categories Compact', 'ai-theme'); }
    public function get_icon() { return 'eicon-folder'; }
    public function get_categories() { return array('ai-theme-categories'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('use_woocommerce', array('label' => __('Use WooCommerce Categories', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->add_control('count', array('label' => __('Count', 'ai-theme'), 'type' => Controls_Manager::NUMBER, 'default' => 8));
        $this->add_control('show_count', array('label' => __('Show Product Count', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->add_control('show_description', array('label' => __('Show Description', 'ai-theme'), 'type' => Controls_Manager::SWITCHER, 'default' => 'yes'));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        
        if ($settings['use_woocommerce'] === 'yes' && class_exists('WooCommerce')) {
            $categories = get_terms(array('taxonomy' => 'product_cat', 'hide_empty' => false, 'number' => intval($settings['count'])));
        } else {
            $categories = get_categories(array('number' => intval($settings['count'])));
        }

        // Split into two columns
        $midpoint = ceil(count($categories) / 2);
        $left_column = array_slice($categories, 0, $midpoint);
        $right_column = array_slice($categories, $midpoint);
        ?>
        <section class="py-12 md:py-16 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="categories" data-block-variant="categories-compact">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Header -->
                <?php if (!empty($settings['heading']) || !empty($settings['subheading'])) : ?>
                <div class="flex items-center justify-between mb-8">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-lg bg-[var(--bg-secondary)] flex items-center justify-center">
                            <svg class="w-5 h-5 text-[var(--text-secondary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                            </svg>
                        </div>
                        <div>
                            <?php if (!empty($settings['heading'])) : ?>
                            <h2 class="text-xl font-bold text-[var(--text-primary)]"><?php echo esc_html($settings['heading']); ?></h2>
                            <?php endif; ?>
                            <?php if (!empty($settings['subheading'])) : ?>
                            <p class="text-sm text-[var(--text-muted)]"><?php echo esc_html($settings['subheading']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (!empty($categories)) : ?>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-1">
                    <!-- Left Column -->
                    <div class="divide-y divide-[var(--border-color)]">
                        <?php foreach ($left_column as $cat) : 
                            $thumb_id = get_term_meta($cat->term_id, 'thumbnail_id', true);
                            $image = $thumb_id ? wp_get_attachment_image_url($thumb_id, 'thumbnail') : '';
                            $description = $cat->description ?? '';
                        ?>
                        <a href="<?php echo esc_url(get_term_link($cat)); ?>" class="group flex items-center gap-4 py-4 hover:bg-[var(--bg-secondary)] -mx-3 px-3 rounded-lg transition-colors">
                            <!-- Thumbnail -->
                            <div class="w-14 h-14 rounded-xl overflow-hidden bg-[var(--bg-secondary)] flex-shrink-0">
                                <?php if ($image) : ?>
                                <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($cat->name); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300" />
                                <?php else : ?>
                                <div class="w-full h-full flex items-center justify-center bg-[var(--bg-secondary)]">
                                    <svg class="w-6 h-6 text-[var(--text-muted)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                    </svg>
                                </div>
                                <?php endif; ?>
                            </div>

                            <!-- Info -->
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center justify-between gap-2">
                                    <h3 class="font-semibold text-[var(--text-primary)] group-hover:text-[var(--primary)] transition-colors truncate"><?php echo esc_html($cat->name); ?></h3>
                                    <?php if ($settings['show_count'] === 'yes') : ?>
                                    <span class="text-xs text-[var(--text-muted)] flex-shrink-0"><?php echo $cat->count; ?></span>
                                    <?php endif; ?>
                                </div>
                                <?php if ($settings['show_description'] === 'yes' && $description) : ?>
                                <p class="text-sm text-[var(--text-muted)] truncate mt-0.5"><?php echo esc_html($description); ?></p>
                                <?php endif; ?>
                            </div>

                            <!-- Arrow -->
                            <svg class="w-5 h-5 text-[var(--text-muted)] group-hover:text-[var(--primary)] group-hover:translate-x-1 transition-all flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </a>
                        <?php endforeach; ?>
                    </div>

                    <!-- Right Column -->
                    <div class="divide-y divide-[var(--border-color)]">
                        <?php foreach ($right_column as $cat) :
                            $thumb_id = get_term_meta($cat->term_id, 'thumbnail_id', true);
                            $image = $thumb_id ? wp_get_attachment_image_url($thumb_id, 'thumbnail') : '';
                            $description = $cat->description ?? '';
                        ?>
                        <a href="<?php echo esc_url(get_term_link($cat)); ?>" class="group flex items-center gap-4 py-4 hover:bg-[var(--bg-secondary)] -mx-3 px-3 rounded-lg transition-colors">
                            <!-- Thumbnail -->
                            <div class="w-14 h-14 rounded-xl overflow-hidden bg-[var(--bg-secondary)] flex-shrink-0">
                                <?php if ($image) : ?>
                                <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($cat->name); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300" />
                                <?php else : ?>
                                <div class="w-full h-full flex items-center justify-center bg-[var(--bg-secondary)]">
                                    <svg class="w-6 h-6 text-[var(--text-muted)]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                    </svg>
                                </div>
                                <?php endif; ?>
                            </div>

                            <!-- Info -->
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center justify-between gap-2">
                                    <h3 class="font-semibold text-[var(--text-primary)] group-hover:text-[var(--primary)] transition-colors truncate"><?php echo esc_html($cat->name); ?></h3>
                                    <?php if ($settings['show_count'] === 'yes') : ?>
                                    <span class="text-xs text-[var(--text-muted)] flex-shrink-0"><?php echo $cat->count; ?></span>
                                    <?php endif; ?>
                                </div>
                                <?php if ($settings['show_description'] === 'yes' && $description) : ?>
                                <p class="text-sm text-[var(--text-muted)] truncate mt-0.5"><?php echo esc_html($description); ?></p>
                                <?php endif; ?>
                            </div>

                            <!-- Arrow -->
                            <svg class="w-5 h-5 text-[var(--text-muted)] group-hover:text-[var(--primary)] group-hover:translate-x-1 transition-all flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </a>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php else : ?>
                <!-- Empty State -->
                <div class="text-center py-12">
                    <svg class="w-12 h-12 text-[var(--text-muted)] mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                    <p class="text-[var(--text-muted)]"><?php _e('No categories found', 'ai-theme'); ?></p>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
