<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cases_Timeline extends AI_Widget_Base {
    public function get_name() { return 'ai_cases_timeline'; }
    public function get_title() { return __('Cases Timeline', 'ai-theme'); }
    public function get_icon() { return 'eicon-time-line'; }
    public function get_categories() { return array('ai-theme-cases'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $repeater = new Repeater();
        $repeater->add_control('year', ['label' => __('Year', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('client', ['label' => __('Client', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('link', ['label' => __('Link', 'ai-theme'), 'type' => Controls_Manager::URL]);

        $this->add_control('cases', ['label' => __('Cases', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $cases = $s['cases'] ?? [];
        ?>
        <section class="section-light py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cases" data-block-variant="cases-timeline">
            <div class="max-w-5xl mx-auto px-6">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-lg text-[var(--text-secondary)]"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <div class="relative">
                    <!-- Timeline line -->
                    <div class="absolute left-8 top-0 bottom-0 w-0.5 bg-[var(--border-color,#e5e7eb)]"></div>

                    <div class="space-y-12">
                        <?php foreach ($cases as $idx => $case) : ?>
                        <div class="relative flex gap-8">
                            <!-- Year marker -->
                            <div class="relative z-10 flex-shrink-0 w-16 h-16 bg-[var(--primary)] rounded-full flex items-center justify-center">
                                <span class="text-white font-bold text-sm"><?php echo esc_html($case['year'] ?? ''); ?></span>
                            </div>

                            <!-- Content -->
                            <div class="flex-1 bg-[var(--bg-secondary)] rounded-2xl p-6 hover:shadow-lg transition-shadow">
                                <div class="flex flex-col md:flex-row gap-6">
                                    <?php if (!empty($case['image']['url'])) : ?>
                                    <img src="<?php echo esc_url($case['image']['url']); ?>" alt="<?php echo esc_attr($case['title']); ?>" class="w-full md:w-48 h-32 object-cover rounded-xl">
                                    <?php endif; ?>
                                    <div class="flex-1">
                                        <h4 class="text-xl font-bold text-[var(--text-primary)] mb-1"><?php echo esc_html($case['title']); ?></h4>
                                        <?php if (!empty($case['client'])) : ?>
                                        <p class="text-[var(--primary)] text-sm font-medium mb-2"><?php echo esc_html($case['client']); ?></p>
                                        <?php endif; ?>
                                        <?php if (!empty($case['description'])) : ?>
                                        <p class="text-[var(--text-secondary)] text-sm"><?php echo esc_html($case['description']); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
