<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Cases_Stats extends AI_Widget_Base {
    public function get_name() { return 'ai_cases_stats'; }
    public function get_title() { return __('Cases Stats', 'ai-theme'); }
    public function get_icon() { return 'eicon-number-field'; }
    public function get_categories() { return array('ai-theme-cases'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('subheading', ['label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('client', ['label' => __('Client', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('stat_metric', ['label' => __('Stat Metric', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('stat_label', ['label' => __('Stat Label', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('link', ['label' => __('Link', 'ai-theme'), 'type' => Controls_Manager::URL]);

        $this->add_control('cases', ['label' => __('Cases', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $cases = $s['cases'] ?? [];
        ?>
        <section class="section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="cases" data-block-variant="cases-stats">
            <div class="max-w-7xl mx-auto px-6">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="text-center mb-12">
                    <?php if (!empty($s['heading'])) : ?>
                    <h2 class="text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($s['subheading'])) : ?>
                    <p class="text-lg text-[var(--text-secondary)]"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <?php foreach ($cases as $case) : ?>
                    <div class="bg-[var(--bg-primary)] rounded-2xl p-6 text-center shadow-md hover:shadow-lg transition-shadow">
                        <?php if (!empty($case['stat_metric'])) : ?>
                        <div class="text-4xl font-bold text-[var(--primary)] mb-2"><?php echo esc_html($case['stat_metric']); ?></div>
                        <?php endif; ?>
                        <?php if (!empty($case['stat_label'])) : ?>
                        <div class="text-sm text-[var(--text-muted)] mb-4"><?php echo esc_html($case['stat_label']); ?></div>
                        <?php endif; ?>
                        <h4 class="text-lg font-semibold text-[var(--text-primary)] mb-1"><?php echo esc_html($case['title']); ?></h4>
                        <?php if (!empty($case['client'])) : ?>
                        <p class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($case['client']); ?></p>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
