<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class About_Stats extends AI_Widget_Base {
    public function get_name() { return 'ai_about_stats'; }
    public function get_title() { return __('About Stats', 'ai-theme'); }
    public function get_icon() { return 'eicon-counter'; }
    public function get_categories() { return array('ai-theme-about'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $this->add_control('image', array('label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA));

        $repeater = new Repeater();
        $repeater->add_control('number', array('label' => __('Number', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('suffix', array('label' => __('Suffix', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('label', array('label' => __('Label', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $this->add_control('stats', array('label' => __('Stats', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-20 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="about" data-block-variant="about-stats">
            <div class="max-w-6xl mx-auto px-6">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    <div>
                        <?php if (!empty($settings['heading'])) : ?>
                            <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-6"><?php echo esc_html($settings['heading']); ?></h2>
                        <?php endif; ?>
                        <?php if (!empty($settings['description'])) : ?>
                            <p class="text-lg text-[var(--text-secondary)] mb-8"><?php echo esc_html($settings['description']); ?></p>
                        <?php endif; ?>
                        <div class="grid grid-cols-3 gap-6">
                            <?php foreach ($settings['stats'] as $stat) : ?>
                                <div class="text-center">
                                    <div class="text-3xl md:text-4xl font-bold text-[var(--primary)]">
                                        <?php echo esc_html($stat['number'] . $stat['suffix']); ?>
                                    </div>
                                    <div class="text-sm text-[var(--text-secondary)] mt-1"><?php echo esc_html($stat['label']); ?></div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php if (!empty($settings['image']['url'])) : ?>
                        <div class="rounded-[var(--card-radius)] overflow-hidden">
                            <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="" class="w-full h-auto" />
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
