<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class About_Image_Left extends AI_Widget_Base {

    public function get_name() { return 'ai_about_image_left'; }
    public function get_title() { return __('About Image Left', 'ai-theme'); }
    public function get_icon() { return 'eicon-image-box'; }
    public function get_categories() { return array('ai-theme-about'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);

        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subtitle', ['label' => __('Subtitle', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('image', ['label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA]);

        $repeater = new Repeater();
        $repeater->add_control('text', ['label' => __('Feature', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('features', ['label' => __('Features', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);

        $this->add_control('cta_text', ['label' => __('CTA Text', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $this->add_control('cta_link', ['label' => __('CTA Link', 'ai-theme'), 'type' => Controls_Manager::URL]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        $bg_style = !empty($s['image']['url']) ? 'background-image: url(' . esc_url($s['image']['url']) . '); background-size: cover; background-position: center;' : '';
        $title = !empty($s['title']) ? $s['title'] : ai_get_text('navigation.labels.about', '');
        ?>
        <section class="ai-about ai-about-image-left py-20 section-secondary" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="about" data-block-variant="about-image-left">
            <div class="ai-container">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                    <div class="ai-about-image h-96 rounded-2xl" style="<?php echo $bg_style; ?> background-color: var(--primary); background-image: <?php echo $bg_style ? '' : 'linear-gradient(to bottom right, var(--primary), var(--secondary))'; ?>;">
                    </div>
                    <div class="ai-about-content space-y-6">
                        <?php if (!empty($s['subtitle'])) : ?><p class="ai-about-subtitle text-[var(--primary)] font-semibold uppercase tracking-wide"><?php echo esc_html($s['subtitle']); ?></p><?php endif; ?>
                        <h2 class="ai-about-title text-4xl font-bold text-[var(--text-primary)]"><?php echo esc_html($title); ?></h2>
                        <?php if (!empty($s['description'])) : ?><p class="ai-about-description text-lg text-[var(--text-secondary)] leading-relaxed"><?php echo esc_html($s['description']); ?></p><?php endif; ?>
                        <?php if (!empty($s['features'])) : ?>
                        <ul class="ai-about-features space-y-2">
                            <?php foreach ($s['features'] as $f) : ?><li class="text-[var(--text-secondary)]"><?php echo esc_html($f['text']); ?></li><?php endforeach; ?>
                        </ul>
                        <?php endif; ?>
                        <?php if (!empty($s['cta_text'])) : ?><a href="<?php echo esc_url($s['cta_link']['url'] ?? '#'); ?>" class="ai-btn inline-block bg-[var(--primary)] text-[var(--text-on-primary)] px-6 py-3 rounded-lg font-semibold hover:opacity-90 transition-colors"><?php echo esc_html($s['cta_text']); ?></a><?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
